/*
  This file is derived from

  amp MPEG audio decoder (version 0.7.3)
  (C) Tomislav Uzelac  1996,1997

This software can be used freely for any purpose. It can be distributed
freely, as long as it is not sold commercially without permission from
Tomislav Uzelac <tuzelac@rasip.fer.hr>. However, including this software
on CD_ROMs containing other free software is explicitly permitted even 
when a modest distribution fee is charged for the CD, as long as this
software is not a primary selling argument for the CD.

Building derived versions of this software is permitted, as long as they
are not sold commercially without permission from Tomislav Uzelac 
<tuzelac@rasip.fer.hr>. Any derived versions must be clearly marked as
such, and must be called by a name other than amp. Any derived versions
must retain this copyright notice.
*/

/* buffer for the 'bit reservoir'
*/
#define BUFFER_SIZE     4096
#define BUFFER_AUX      2048

typedef struct mp3Info {
  unsigned int headerInt;
  int gotHeader;
  int bytesPerFrame;
  int id;
  int cnt;
  char rest[18][32][8][4];
  int restlen;
  int ind;
  int bufind;
  unsigned char buffer[BUFFER_SIZE+BUFFER_AUX];
  int append;
  int data;
  float u[2][2][32][16];
  int u_start[2];
  int u_div[2];
  int bitrate;
} mp3Info;

/* "audio.h" */

struct AUDIO_HEADER {
	int ID;
	int layer;
	int protection_bit;
	int bitrate_index;
	int sampling_frequency;
	int padding_bit;
	int private_bit;
	int mode;
	int mode_extension;
	int copyright;
	int original;
	int emphasis;
};

struct SIDE_INFO {
	int main_data_begin;
	int scfsi[2][4];
	int part2_3_length[2][2];
	int big_values[2][2];
	int global_gain[2][2];
	int scalefac_compress[2][2];
	int window_switching_flag[2][2];
	int block_type[2][2];
	int mixed_block_flag[2][2];
	int table_select[2][2][3];
	int subblock_gain[2][2][3];
	int region0_count[2][2];
	int region1_count[2][2];
	int preflag[2][2];
	int scalefac_scale[2][2];
	int count1table_select[2][2];
};

int scalefac_l[2][2][22];
int scalefac_s[2][2][13][3];

int is[2][578];
float xr[2][32][18];

int *t_l,*t_s;
int nch;
int t_sampling_frequency[2][3] = {
{ 22050 , 24000 , 16000},
{ 44100 , 48000 , 32000}
};

int SHOW_HEADER,SHOW_HEADER_DETAIL;
int SHOW_SIDE_INFO,SHOW_SIDE_INFO_DETAIL;
int SHOW_MDB,SHOW_MDB_DETAIL;
int SHOW_HUFFMAN_ERRORS,SHOW_HUFFBITS;
int SHOW_SCFSI,SHOW_BLOCK_TYPE,SHOW_TABLES,SHOW_BITRATE;
int A_QUIET,A_SHOW_CNT,A_FORMAT_WAVE,A_DUMP_BINARY, A_OSCI;
int A_WRITE_TO_FILE;
int A_AUDIO_PLAY;
int A_SET_VOLUME, A_SHOW_TIME;
int A_MSG_STDOUT;

short t_bitrate[2][3][15] = {{
{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256},
{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160},
{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160}
},{
{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448},
{0,32,48,56,64,80,96,112,128,160,192,224,256,320,384},
{0,32,40,48,56,64,80,96,112,128,160,192,224,256,320}
}};

/* the last sfb is given implicitly on pg.28. of the standard. scalefactors 
 * for that one are 0, pretab also 
 */
/* leftmost index denotes ID, so first three tables are for MPEG2 (header->ID==0)
 * and the other three are for MPEG1 (header->ID==1)
 */
/* 22.05, 24, 16 */
int t_b8_l[2][3][22]={{ /* table B.8b ISO/IEC 11172-3 */
{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575},
{5,11,17,23,29,35,43,53,65,79,95,113,135,161,193,231,277,331,393,463,539,575},
{5,11,17,23,29,35,43,53,65,79,95,115,139,167,199,237,283,335,395,463,521,575}
},{
{3,7,11,15,19,23,29,35,43,51,61,73,89,109,133,161,195,237,287,341,417,575},
{3,7,11,15,19,23,29,35,41,49,59,71,87,105,127,155,189,229,275,329,383,575},
{3,7,11,15,19,23,29,35,43,53,65,81,101,125,155,193,239,295,363,447,549,575}
}};   
int t_b8_s[2][3][13]={{ /* table B.8b ISO/IEC 11172-3 */
{3,7,11,17,23,31,41,55,73,99,131,173,191},
{3,7,11,17,25,35,47,61,79,103,135,179,191},
{3,7,11,17,25,35,47,61,79,103,133,173,191}
},{
{3,7,11,15,21,29,39,51,65,83,105,135,191},
{3,7,11,15,21,27,37,49,63,79,99,125,191},
{3,7,11,15,21,29,41,57,77,103,137,179,191}
}};

/* "getbits.h" */

/* gethdr() error codes: NS == not supported
*/
#define GETHDR_ERR 1
#define GETHDR_NS  2

/* buffer, AUX is used in case of input buffer "overflow", and its contents
 * are copied to the beginning of the buffer
*/
unsigned char *buffer;

/* buffer pointers 
 * append counts in bytes, data in bits
 */
  int append;
  int data;

/* internal buffer, _bptr holds the position in _bits_
*/
static unsigned char _buffer[32];
static int _bptr;

static unsigned int _getbits(int n);
static int _fillbfr(int size);
static void getinfo(struct AUDIO_HEADER *header,struct SIDE_INFO *info);
static int gethdr(struct AUDIO_HEADER *header);
static void getcrc();
static int fillbfr(int advance);
static unsigned int viewbits(int n);
static void sackbits(int n);
static unsigned int getbits(int n);
  
/* getdata.h */
 
static char t_slen1[16]={0,0,0,0,3,1,1,1,2,2,2,3,3,3,4,4};
static char t_slen2[16]={0,1,2,3,0,1,2,3,1,2,3,1,2,3,2,3};
static int t_linbits[32]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,6,8,10,13,4,5,6,7,8,9,11,13};

int non_zero[2]; /* this is 2*bigvalues+4*count1, i guess...*/
int is_max[21]; /* the maximum value of is_pos. for short blocks is_max[sfb=0] == is_max[6],
	   	 * it's sloppy but i'm sick of waisting storage. blaah...
		 */
int intensity_scale;

static  int _qsign(int x,int *q);
static int decode_scalefactors(struct SIDE_INFO *info,struct AUDIO_HEADER *header,int gr,int ch);
static int decode_huffman_data(struct SIDE_INFO *info,int gr,int ch,int ssize);

/* my implementation of MPEG2 scalefactor decoding is, admitably, horrible
 * anyway, just take a look at pg.18 of MPEG2 specs, and you'll know what
 * this is all about
 */
static const char spooky_table[2][3][3][4]={
{
{ {6,5,5,5},   {9,9,9,9},   {6,9,9,9} },
{ {6,5,7,3},   {9,9,12,6},  {6,9,12,6}},
{ {11,10,0,0}, {18,18,0,0}, {15,18,0,0}} 
},
{
{ {7,7,7,0},   {12,12,12,0}, {6,15,12,0}},
{ {6,6,6,3},   {12,9,9,6},   {6,12,9,6}},
{ {8,8,5,0},   {15,12,9,0},  {6,18,9,0}}
}};

/* misc2.h */

#define i_sq2   0.707106781188
#define IS_ILLEGAL 0xfeed

static void requantize_mono(int gr,int ch,struct SIDE_INFO *info,struct AUDIO_HEADER *header);
static void requantize_ms(int gr,struct SIDE_INFO *info,struct AUDIO_HEADER *header);
static void alias_reduction(int ch);

static  float fras_l(int sfb,int global_gain,int scalefac_scale,int scalefac,int preflag);
static  float fras_s(int global_gain,int subblock_gain,int scalefac_scale,int scalefac);
static  float fras2(int is,float a);
static int find_isbound(int isbound[3],int gr,struct SIDE_INFO *info,struct AUDIO_HEADER *header);
static  void stereo_s(int l,float a[2],int pos,int ms_flag,int is_pos,struct AUDIO_HEADER *header);
static  void stereo_l(int l,float a[2],int ms_flag,int is_pos,struct AUDIO_HEADER *header);

int no_of_imdcts[2];

static const int t_pretab[22]={0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,3,3,3,2,0};
static const float t_is[7]={ 1.0f, 0.788675134596f, 0.633974596215f,
		 0.5f, 0.366025403784f, 0.211324865405f, 0.0f};
static const float t_is2[2][32]={
{             1.0f,       0.840896f,       0.707107f,       0.594604f,            0.5f,       0.420448f,
       0.353553f,       0.297302f,           0.25f,       0.210224f,       0.176777f,       0.148651f,
          0.125f,       0.105112f,      0.0883883f,      0.0743254f},
{             1.0f,       0.707107f,            0.5f,       0.353553f,           0.25f,       0.176777f,
          0.125f,      0.0883883f,         0.0625f,      0.0441942f,        0.03125f,      0.0220971f,
       0.015625f,      0.0110485f,      0.0078125f,     0.00552427f}
};
static const float Cs[8]={0.857492925712f, 0.881741997318f, 0.949628649103f,
	      0.983314592492f, 0.995517816065f, 0.999160558175f,
	      0.999899195243f, 0.999993155067f};
static const float Ca[8]={-0.5144957554270f, -0.4717319685650f, -0.3133774542040f,
	      -0.1819131996110f, -0.0945741925262f, -0.0409655828852f,
	      -0.0141985685725f,	-0.00369997467375f};
static const float tab[4]={1.f,1.189207115f,1.414213562f,1.6817928301f};
static const float tabi[4]={1.f,0.840896415f,0.707106781f,0.594603557f};

/* leftmost index denotes header->ID, so first three are for MPEG2
 * and the others are for MPEG1
 */
static const short t_reorder[2][3][576]={{
{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  60,  61,  62,  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  90,  91,
  78,  79,  80,  81,  82,  83,  96,  97,  84,  85,  86,  87,  88,  89, 102, 103,  92,  93,  94,  95,
 108, 109, 110, 111, 112, 113,  98,  99, 100, 101, 114, 115, 116, 117, 118, 119, 104, 105, 106, 107,
 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 144, 145, 146, 147, 148, 149, 162, 163,
 132, 133, 134, 135, 136, 137, 150, 151, 152, 153, 154, 155, 168, 169, 138, 139, 140, 141, 142, 143,
 156, 157, 158, 159, 160, 161, 174, 175, 164, 165, 166, 167, 180, 181, 182, 183, 184, 185, 198, 199,
 200, 201, 202, 203, 216, 217, 170, 171, 172, 173, 186, 187, 188, 189, 190, 191, 204, 205, 206, 207,
 208, 209, 222, 223, 176, 177, 178, 179, 192, 193, 194, 195, 196, 197, 210, 211, 212, 213, 214, 215,
 228, 229, 218, 219, 220, 221, 234, 235, 236, 237, 238, 239, 252, 253, 254, 255, 256, 257, 270, 271,
 272, 273, 274, 275, 288, 289, 290, 291, 224, 225, 226, 227, 240, 241, 242, 243, 244, 245, 258, 259,
 260, 261, 262, 263, 276, 277, 278, 279, 280, 281, 294, 295, 296, 297, 230, 231, 232, 233, 246, 247,
 248, 249, 250, 251, 264, 265, 266, 267, 268, 269, 282, 283, 284, 285, 286, 287, 300, 301, 302, 303,
 292, 293, 306, 307, 308, 309, 310, 311, 324, 325, 326, 327, 328, 329, 342, 343, 344, 345, 346, 347,
 360, 361, 362, 363, 364, 365, 378, 379, 380, 381, 382, 383, 298, 299, 312, 313, 314, 315, 316, 317,
 330, 331, 332, 333, 334, 335, 348, 349, 350, 351, 352, 353, 366, 367, 368, 369, 370, 371, 384, 385,
 386, 387, 388, 389, 304, 305, 318, 319, 320, 321, 322, 323, 336, 337, 338, 339, 340, 341, 354, 355,
 356, 357, 358, 359, 372, 373, 374, 375, 376, 377, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399,
 400, 401, 414, 415, 416, 417, 418, 419, 432, 433, 434, 435, 436, 437, 450, 451, 452, 453, 454, 455,
 468, 469, 470, 471, 472, 473, 486, 487, 488, 489, 490, 491, 504, 505, 506, 507, 508, 509, 402, 403,
 404, 405, 406, 407, 420, 421, 422, 423, 424, 425, 438, 439, 440, 441, 442, 443, 456, 457, 458, 459,
 460, 461, 474, 475, 476, 477, 478, 479, 492, 493, 494, 495, 496, 497, 510, 511, 512, 513, 514, 515,
 408, 409, 410, 411, 412, 413, 426, 427, 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463,
 464, 465, 466, 467, 480, 481, 482, 483, 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519,
 520, 521, 522, 523, 524, 525, 526, 527, 540, 541, 542, 543, 544, 545, 558, 559, 560, 561, 562, 563,
 528, 529, 530, 531, 532, 533, 546, 547, 548, 549, 550, 551, 564, 565, 566, 567, 568, 569, 534, 535,
 536, 537, 538, 539, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575},

{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  72,  73,  60,  61,  62,  63,  64,  65,  78,  79,  66,  67,  68,  69,  70,  71,  84,  85,  74,  75,
  76,  77,  90,  91,  92,  93,  94,  95,  80,  81,  82,  83,  96,  97,  98,  99, 100, 101,  86,  87,
  88,  89, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 126, 127, 128, 129, 130, 131,
 114, 115, 116, 117, 118, 119, 132, 133, 134, 135, 136, 137, 120, 121, 122, 123, 124, 125, 138, 139,
 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 162, 163, 164, 165, 166, 167, 180, 181, 150, 151,
 152, 153, 154, 155, 168, 169, 170, 171, 172, 173, 186, 187, 156, 157, 158, 159, 160, 161, 174, 175,
 176, 177, 178, 179, 192, 193, 182, 183, 184, 185, 198, 199, 200, 201, 202, 203, 216, 217, 218, 219,
 220, 221, 234, 235, 188, 189, 190, 191, 204, 205, 206, 207, 208, 209, 222, 223, 224, 225, 226, 227,
 240, 241, 194, 195, 196, 197, 210, 211, 212, 213, 214, 215, 228, 229, 230, 231, 232, 233, 246, 247,
 236, 237, 238, 239, 252, 253, 254, 255, 256, 257, 270, 271, 272, 273, 274, 275, 288, 289, 290, 291,
 292, 293, 306, 307, 242, 243, 244, 245, 258, 259, 260, 261, 262, 263, 276, 277, 278, 279, 280, 281,
 294, 295, 296, 297, 298, 299, 312, 313, 248, 249, 250, 251, 264, 265, 266, 267, 268, 269, 282, 283,
 284, 285, 286, 287, 300, 301, 302, 303, 304, 305, 318, 319, 308, 309, 310, 311, 324, 325, 326, 327,
 328, 329, 342, 343, 344, 345, 346, 347, 360, 361, 362, 363, 364, 365, 378, 379, 380, 381, 382, 383,
 396, 397, 398, 399, 314, 315, 316, 317, 330, 331, 332, 333, 334, 335, 348, 349, 350, 351, 352, 353,
 366, 367, 368, 369, 370, 371, 384, 385, 386, 387, 388, 389, 402, 403, 404, 405, 320, 321, 322, 323,
 336, 337, 338, 339, 340, 341, 354, 355, 356, 357, 358, 359, 372, 373, 374, 375, 376, 377, 390, 391,
 392, 393, 394, 395, 408, 409, 410, 411, 400, 401, 414, 415, 416, 417, 418, 419, 432, 433, 434, 435,
 436, 437, 450, 451, 452, 453, 454, 455, 468, 469, 470, 471, 472, 473, 486, 487, 488, 489, 490, 491,
 504, 505, 506, 507, 508, 509, 522, 523, 524, 525, 526, 527, 406, 407, 420, 421, 422, 423, 424, 425,
 438, 439, 440, 441, 442, 443, 456, 457, 458, 459, 460, 461, 474, 475, 476, 477, 478, 479, 492, 493,
 494, 495, 496, 497, 510, 511, 512, 513, 514, 515, 528, 529, 530, 531, 532, 533, 412, 413, 426, 427,
 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463, 464, 465, 466, 467, 480, 481, 482, 483,
 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519, 520, 521, 534, 535, 536, 537, 538, 539,
 540, 541, 542, 543, 544, 545, 558, 559, 560, 561, 562, 563, 546, 547, 548, 549, 550, 551, 564, 565,
 566, 567, 568, 569, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575},

{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  40,  41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
  72,  73,  60,  61,  62,  63,  64,  65,  78,  79,  66,  67,  68,  69,  70,  71,  84,  85,  74,  75,
  76,  77,  90,  91,  92,  93,  94,  95,  80,  81,  82,  83,  96,  97,  98,  99, 100, 101,  86,  87,
  88,  89, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 126, 127, 128, 129, 130, 131,
 114, 115, 116, 117, 118, 119, 132, 133, 134, 135, 136, 137, 120, 121, 122, 123, 124, 125, 138, 139,
 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 162, 163, 164, 165, 166, 167, 180, 181, 150, 151,
 152, 153, 154, 155, 168, 169, 170, 171, 172, 173, 186, 187, 156, 157, 158, 159, 160, 161, 174, 175,
 176, 177, 178, 179, 192, 193, 182, 183, 184, 185, 198, 199, 200, 201, 202, 203, 216, 217, 218, 219,
 220, 221, 234, 235, 188, 189, 190, 191, 204, 205, 206, 207, 208, 209, 222, 223, 224, 225, 226, 227,
 240, 241, 194, 195, 196, 197, 210, 211, 212, 213, 214, 215, 228, 229, 230, 231, 232, 233, 246, 247,
 236, 237, 238, 239, 252, 253, 254, 255, 256, 257, 270, 271, 272, 273, 274, 275, 288, 289, 290, 291,
 292, 293, 306, 307, 242, 243, 244, 245, 258, 259, 260, 261, 262, 263, 276, 277, 278, 279, 280, 281,
 294, 295, 296, 297, 298, 299, 312, 313, 248, 249, 250, 251, 264, 265, 266, 267, 268, 269, 282, 283,
 284, 285, 286, 287, 300, 301, 302, 303, 304, 305, 318, 319, 308, 309, 310, 311, 324, 325, 326, 327,
 328, 329, 342, 343, 344, 345, 346, 347, 360, 361, 362, 363, 364, 365, 378, 379, 380, 381, 382, 383,
 396, 397, 314, 315, 316, 317, 330, 331, 332, 333, 334, 335, 348, 349, 350, 351, 352, 353, 366, 367,
 368, 369, 370, 371, 384, 385, 386, 387, 388, 389, 402, 403, 320, 321, 322, 323, 336, 337, 338, 339,
 340, 341, 354, 355, 356, 357, 358, 359, 372, 373, 374, 375, 376, 377, 390, 391, 392, 393, 394, 395,
 408, 409, 398, 399, 400, 401, 414, 415, 416, 417, 418, 419, 432, 433, 434, 435, 436, 437, 450, 451,
 452, 453, 454, 455, 468, 469, 470, 471, 472, 473, 486, 487, 488, 489, 490, 491, 504, 505, 506, 507,
 508, 509, 404, 405, 406, 407, 420, 421, 422, 423, 424, 425, 438, 439, 440, 441, 442, 443, 456, 457,
 458, 459, 460, 461, 474, 475, 476, 477, 478, 479, 492, 493, 494, 495, 496, 497, 510, 511, 512, 513,
 514, 515, 410, 411, 412, 413, 426, 427, 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463,
 464, 465, 466, 467, 480, 481, 482, 483, 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519,
 520, 521, 522, 523, 524, 525, 526, 527, 540, 541, 542, 543, 544, 545, 558, 559, 560, 561, 562, 563,
 528, 529, 530, 531, 532, 533, 546, 547, 548, 549, 550, 551, 564, 565, 566, 567, 568, 569, 534, 535,
 536, 537, 538, 539, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575}
},
{
{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  42,  43,  44,  45,  48,  49,  50,  51,  40,  41,  54,  55,  56,  57,  46,  47,  60,  61,  62,  63,
  52,  53,  66,  67,  68,  69,  58,  59,  72,  73,  74,  75,  76,  77,  64,  65,  78,  79,  80,  81,
  82,  83,  70,  71,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, 108, 109, 110, 111,
  96,  97,  98,  99, 100, 101, 114, 115, 116, 117, 102, 103, 104, 105, 106, 107, 120, 121, 122, 123,
 112, 113, 126, 127, 128, 129, 130, 131, 144, 145, 146, 147, 118, 119, 132, 133, 134, 135, 136, 137,
 150, 151, 152, 153, 124, 125, 138, 139, 140, 141, 142, 143, 156, 157, 158, 159, 148, 149, 162, 163,
 164, 165, 166, 167, 180, 181, 182, 183, 184, 185, 154, 155, 168, 169, 170, 171, 172, 173, 186, 187,
 188, 189, 190, 191, 160, 161, 174, 175, 176, 177, 178, 179, 192, 193, 194, 195, 196, 197, 198, 199,
 200, 201, 202, 203, 216, 217, 218, 219, 220, 221, 234, 235, 236, 237, 238, 239, 204, 205, 206, 207,
 208, 209, 222, 223, 224, 225, 226, 227, 240, 241, 242, 243, 244, 245, 210, 211, 212, 213, 214, 215,
 228, 229, 230, 231, 232, 233, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 270, 271,
 272, 273, 274, 275, 288, 289, 290, 291, 292, 293, 306, 307, 308, 309, 258, 259, 260, 261, 262, 263,
 276, 277, 278, 279, 280, 281, 294, 295, 296, 297, 298, 299, 312, 313, 314, 315, 264, 265, 266, 267,
 268, 269, 282, 283, 284, 285, 286, 287, 300, 301, 302, 303, 304, 305, 318, 319, 320, 321, 310, 311,
 324, 325, 326, 327, 328, 329, 342, 343, 344, 345, 346, 347, 360, 361, 362, 363, 364, 365, 378, 379,
 380, 381, 382, 383, 396, 397, 398, 399, 316, 317, 330, 331, 332, 333, 334, 335, 348, 349, 350, 351,
 352, 353, 366, 367, 368, 369, 370, 371, 384, 385, 386, 387, 388, 389, 402, 403, 404, 405, 322, 323,
 336, 337, 338, 339, 340, 341, 354, 355, 356, 357, 358, 359, 372, 373, 374, 375, 376, 377, 390, 391,
 392, 393, 394, 395, 408, 409, 410, 411, 400, 401, 414, 415, 416, 417, 418, 419, 432, 433, 434, 435,
 436, 437, 450, 451, 452, 453, 454, 455, 468, 469, 470, 471, 472, 473, 486, 487, 488, 489, 490, 491,
 504, 505, 506, 507, 508, 509, 522, 523, 524, 525, 526, 527, 540, 541, 542, 543, 544, 545, 558, 559,
 560, 561, 562, 563, 406, 407, 420, 421, 422, 423, 424, 425, 438, 439, 440, 441, 442, 443, 456, 457,
 458, 459, 460, 461, 474, 475, 476, 477, 478, 479, 492, 493, 494, 495, 496, 497, 510, 511, 512, 513,
 514, 515, 528, 529, 530, 531, 532, 533, 546, 547, 548, 549, 550, 551, 564, 565, 566, 567, 568, 569,
 412, 413, 426, 427, 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463, 464, 465, 466, 467,
 480, 481, 482, 483, 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519, 520, 521, 534, 535,
 536, 537, 538, 539, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575},

{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  42,  43,  44,  45,  48,  49,  50,  51,  40,  41,  54,  55,  56,  57,  46,  47,  60,  61,  62,  63,
  52,  53,  66,  67,  68,  69,  58,  59,  72,  73,  74,  75,  64,  65,  78,  79,  80,  81,  70,  71,
  84,  85,  86,  87,  76,  77,  90,  91,  92,  93,  94,  95, 108, 109,  82,  83,  96,  97,  98,  99,
 100, 101, 114, 115,  88,  89, 102, 103, 104, 105, 106, 107, 120, 121, 110, 111, 112, 113, 126, 127,
 128, 129, 130, 131, 144, 145, 116, 117, 118, 119, 132, 133, 134, 135, 136, 137, 150, 151, 122, 123,
 124, 125, 138, 139, 140, 141, 142, 143, 156, 157, 146, 147, 148, 149, 162, 163, 164, 165, 166, 167,
 180, 181, 182, 183, 152, 153, 154, 155, 168, 169, 170, 171, 172, 173, 186, 187, 188, 189, 158, 159,
 160, 161, 174, 175, 176, 177, 178, 179, 192, 193, 194, 195, 184, 185, 198, 199, 200, 201, 202, 203,
 216, 217, 218, 219, 220, 221, 234, 235, 190, 191, 204, 205, 206, 207, 208, 209, 222, 223, 224, 225,
 226, 227, 240, 241, 196, 197, 210, 211, 212, 213, 214, 215, 228, 229, 230, 231, 232, 233, 246, 247,
 236, 237, 238, 239, 252, 253, 254, 255, 256, 257, 270, 271, 272, 273, 274, 275, 288, 289, 290, 291,
 242, 243, 244, 245, 258, 259, 260, 261, 262, 263, 276, 277, 278, 279, 280, 281, 294, 295, 296, 297,
 248, 249, 250, 251, 264, 265, 266, 267, 268, 269, 282, 283, 284, 285, 286, 287, 300, 301, 302, 303,
 292, 293, 306, 307, 308, 309, 310, 311, 324, 325, 326, 327, 328, 329, 342, 343, 344, 345, 346, 347,
 360, 361, 362, 363, 364, 365, 298, 299, 312, 313, 314, 315, 316, 317, 330, 331, 332, 333, 334, 335,
 348, 349, 350, 351, 352, 353, 366, 367, 368, 369, 370, 371, 304, 305, 318, 319, 320, 321, 322, 323,
 336, 337, 338, 339, 340, 341, 354, 355, 356, 357, 358, 359, 372, 373, 374, 375, 376, 377, 378, 379,
 380, 381, 382, 383, 396, 397, 398, 399, 400, 401, 414, 415, 416, 417, 418, 419, 432, 433, 434, 435,
 436, 437, 450, 451, 452, 453, 454, 455, 468, 469, 470, 471, 472, 473, 486, 487, 488, 489, 490, 491,
 504, 505, 506, 507, 508, 509, 522, 523, 524, 525, 526, 527, 540, 541, 542, 543, 544, 545, 558, 559,
 560, 561, 562, 563, 384, 385, 386, 387, 388, 389, 402, 403, 404, 405, 406, 407, 420, 421, 422, 423,
 424, 425, 438, 439, 440, 441, 442, 443, 456, 457, 458, 459, 460, 461, 474, 475, 476, 477, 478, 479,
 492, 493, 494, 495, 496, 497, 510, 511, 512, 513, 514, 515, 528, 529, 530, 531, 532, 533, 546, 547,
 548, 549, 550, 551, 564, 565, 566, 567, 568, 569, 390, 391, 392, 393, 394, 395, 408, 409, 410, 411,
 412, 413, 426, 427, 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463, 464, 465, 466, 467,
 480, 481, 482, 483, 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519, 520, 521, 534, 535,
 536, 537, 538, 539, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575},

{  0,   1,   2,   3,   6,   7,   8,   9,  12,  13,  14,  15,   4,   5,  18,  19,  10,  11,  24,  25,
  16,  17,  30,  31,  20,  21,  22,  23,  26,  27,  28,  29,  32,  33,  34,  35,  36,  37,  38,  39,
  42,  43,  44,  45,  48,  49,  50,  51,  40,  41,  54,  55,  56,  57,  46,  47,  60,  61,  62,  63,
  52,  53,  66,  67,  68,  69,  58,  59,  72,  73,  74,  75,  76,  77,  64,  65,  78,  79,  80,  81,
  82,  83,  70,  71,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95, 108, 109, 110, 111,
 112, 113,  96,  97,  98,  99, 100, 101, 114, 115, 116, 117, 118, 119, 102, 103, 104, 105, 106, 107,
 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 144, 145, 146, 147, 148, 149, 162, 163,
 164, 165, 132, 133, 134, 135, 136, 137, 150, 151, 152, 153, 154, 155, 168, 169, 170, 171, 138, 139,
 140, 141, 142, 143, 156, 157, 158, 159, 160, 161, 174, 175, 176, 177, 166, 167, 180, 181, 182, 183,
 184, 185, 198, 199, 200, 201, 202, 203, 216, 217, 218, 219, 220, 221, 172, 173, 186, 187, 188, 189,
 190, 191, 204, 205, 206, 207, 208, 209, 222, 223, 224, 225, 226, 227, 178, 179, 192, 193, 194, 195,
 196, 197, 210, 211, 212, 213, 214, 215, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
 252, 253, 254, 255, 256, 257, 270, 271, 272, 273, 274, 275, 288, 289, 290, 291, 292, 293, 306, 307,
 240, 241, 242, 243, 244, 245, 258, 259, 260, 261, 262, 263, 276, 277, 278, 279, 280, 281, 294, 295,
 296, 297, 298, 299, 312, 313, 246, 247, 248, 249, 250, 251, 264, 265, 266, 267, 268, 269, 282, 283,
 284, 285, 286, 287, 300, 301, 302, 303, 304, 305, 318, 319, 308, 309, 310, 311, 324, 325, 326, 327,
 328, 329, 342, 343, 344, 345, 346, 347, 360, 361, 362, 363, 364, 365, 378, 379, 380, 381, 382, 383,
 396, 397, 398, 399, 400, 401, 314, 315, 316, 317, 330, 331, 332, 333, 334, 335, 348, 349, 350, 351,
 352, 353, 366, 367, 368, 369, 370, 371, 384, 385, 386, 387, 388, 389, 402, 403, 404, 405, 406, 407,
 320, 321, 322, 323, 336, 337, 338, 339, 340, 341, 354, 355, 356, 357, 358, 359, 372, 373, 374, 375,
 376, 377, 390, 391, 392, 393, 394, 395, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419,
 432, 433, 434, 435, 436, 437, 450, 451, 452, 453, 454, 455, 468, 469, 470, 471, 472, 473, 486, 487,
 488, 489, 490, 491, 504, 505, 506, 507, 508, 509, 522, 523, 524, 525, 526, 527, 420, 421, 422, 423,
 424, 425, 438, 439, 440, 441, 442, 443, 456, 457, 458, 459, 460, 461, 474, 475, 476, 477, 478, 479,
 492, 493, 494, 495, 496, 497, 510, 511, 512, 513, 514, 515, 528, 529, 530, 531, 532, 533, 426, 427,
 428, 429, 430, 431, 444, 445, 446, 447, 448, 449, 462, 463, 464, 465, 466, 467, 480, 481, 482, 483,
 484, 485, 498, 499, 500, 501, 502, 503, 516, 517, 518, 519, 520, 521, 534, 535, 536, 537, 538, 539,
 540, 541, 542, 543, 544, 545, 558, 559, 560, 561, 562, 563, 546, 547, 548, 549, 550, 551, 564, 565,
 566, 567, 568, 569, 552, 553, 554, 555, 556, 557, 570, 571, 572, 573, 574, 575}
}};

static const float t_43[8192]={
    0.000000f,    1.000000f,    2.519842f,    4.326749f,    6.349604f,    8.549880f,   10.902724f,   13.390518f,
   16.000000f,   18.720754f,   21.544347f,   24.463781f,   27.473142f,   30.567351f,   33.741992f,   36.993181f,
   40.317474f,   43.711787f,   47.173345f,   50.699631f,   54.288352f,   57.937408f,   61.644865f,   65.408941f,
   69.227979f,   73.100443f,   77.024898f,   81.000000f,   85.024491f,   89.097188f,   93.216975f,   97.382800f,
  101.593667f,  105.848633f,  110.146801f,  114.487321f,  118.869381f,  123.292209f,  127.755065f,  132.257246f,
  136.798076f,  141.376907f,  145.993119f,  150.646117f,  155.335327f,  160.060199f,  164.820202f,  169.614826f,
  174.443577f,  179.305980f,  184.201575f,  189.129918f,  194.090580f,  199.083145f,  204.107210f,  209.162385f,
  214.248292f,  219.364564f,  224.510845f,  229.686789f,  234.892058f,  240.126328f,  245.389280f,  250.680604f,
  256.000000f,  261.347174f,  266.721841f,  272.123723f,  277.552547f,  283.008049f,  288.489971f,  293.998060f,
  299.532071f,  305.091761f,  310.676898f,  316.287249f,  321.922592f,  327.582707f,  333.267377f,  338.976394f,
  344.709550f,  350.466646f,  356.247482f,  362.051866f,  367.879608f,  373.730522f,  379.604427f,  385.501143f,
  391.420496f,  397.362314f,  403.326427f,  409.312672f,  415.320884f,  421.350905f,  427.402579f,  433.475750f,
  439.570269f,  445.685987f,  451.822757f,  457.980436f,  464.158883f,  470.357960f,  476.577530f,  482.817459f,
  489.077615f,  495.357868f,  501.658090f,  507.978156f,  514.317941f,  520.677324f,  527.056184f,  533.454404f,
  539.871867f,  546.308458f,  552.764065f,  559.238575f,  565.731879f,  572.243870f,  578.774440f,  585.323483f,
  591.890898f,  598.476581f,  605.080431f,  611.702349f,  618.342238f,  625.000000f,  631.675540f,  638.368763f,
  645.079578f,  651.807891f,  658.553612f,  665.316653f,  672.096925f,  678.894340f,  685.708813f,  692.540258f,
  699.388593f,  706.253733f,  713.135597f,  720.034104f,  726.949174f,  733.880729f,  740.828689f,  747.792979f,
  754.773522f,  761.770242f,  768.783065f,  775.811917f,  782.856726f,  789.917420f,  796.993927f,  804.086177f,
  811.194101f,  818.317630f,  825.456695f,  832.611230f,  839.781167f,  846.966442f,  854.166988f,  861.382741f,
  868.613637f,  875.859614f,  883.120608f,  890.396558f,  897.687403f,  904.993081f,  912.313534f,  919.648701f,
  926.998523f,  934.362944f,  941.741904f,  949.135347f,  956.543216f,  963.965455f,  971.402010f,  978.852824f,
  986.317844f,  993.797016f, 1001.290286f, 1008.797602f, 1016.318911f, 1023.854161f, 1031.403302f, 1038.966281f,
 1046.543049f, 1054.133555f, 1061.737750f, 1069.355585f, 1076.987011f, 1084.631981f, 1092.290445f, 1099.962357f,
 1107.647670f, 1115.346337f, 1123.058312f, 1130.783550f, 1138.522004f, 1146.273630f, 1154.038383f, 1161.816220f,
 1169.607095f, 1177.410967f, 1185.227790f, 1193.057524f, 1200.900125f, 1208.755551f, 1216.623760f, 1224.504712f,
 1232.398364f, 1240.304677f, 1248.223610f, 1256.155123f, 1264.099175f, 1272.055728f, 1280.024742f, 1288.006179f,
 1296.000000f, 1304.006166f, 1312.024641f, 1320.055385f, 1328.098362f, 1336.153535f, 1344.220866f, 1352.300320f,
 1360.391859f, 1368.495449f, 1376.611053f, 1384.738635f, 1392.878162f, 1401.029597f, 1409.192905f, 1417.368054f,
 1425.555007f, 1433.753732f, 1441.964195f, 1450.186361f, 1458.420199f, 1466.665675f, 1474.922755f, 1483.191409f,
 1491.471603f, 1499.763305f, 1508.066484f, 1516.381107f, 1524.707144f, 1533.044563f, 1541.393333f, 1549.753423f,
 1558.124804f, 1566.507443f, 1574.901312f, 1583.306381f, 1591.722619f, 1600.149996f, 1608.588485f, 1617.038055f,
 1625.498677f, 1633.970323f, 1642.452964f, 1650.946572f, 1659.451118f, 1667.966574f, 1676.492913f, 1685.030106f,
 1693.578126f, 1702.136946f, 1710.706539f, 1719.286878f, 1727.877935f, 1736.479684f, 1745.092099f, 1753.715153f,
 1762.348820f, 1770.993074f, 1779.647889f, 1788.313239f, 1796.989100f, 1805.675444f, 1814.372248f, 1823.079487f,
 1831.797134f, 1840.525165f, 1849.263556f, 1858.012283f, 1866.771320f, 1875.540644f, 1884.320231f, 1893.110056f,
 1901.910095f, 1910.720326f, 1919.540725f, 1928.371268f, 1937.211932f, 1946.062693f, 1954.923530f, 1963.794418f,
 1972.675336f, 1981.566261f, 1990.467169f, 1999.378040f, 2008.298850f, 2017.229578f, 2026.170201f, 2035.120698f,
 2044.081047f, 2053.051227f, 2062.031215f, 2071.020990f, 2080.020532f, 2089.029819f, 2098.048830f, 2107.077544f,
 2116.115940f, 2125.163998f, 2134.221697f, 2143.289017f, 2152.365936f, 2161.452435f, 2170.548495f, 2179.654093f,
 2188.769212f, 2197.893830f, 2207.027929f, 2216.171488f, 2225.324488f, 2234.486909f, 2243.658733f, 2252.839939f,
 2262.030510f, 2271.230425f, 2280.439666f, 2289.658214f, 2298.886050f, 2308.123156f, 2317.369513f, 2326.625102f,
 2335.889905f, 2345.163905f, 2354.447082f, 2363.739418f, 2373.040896f, 2382.351497f, 2391.671205f, 2401.000000f,
 2410.337866f, 2419.684784f, 2429.040737f, 2438.405709f, 2447.779680f, 2457.162635f, 2466.554556f, 2475.955426f,
 2485.365228f, 2494.783945f, 2504.211560f, 2513.648057f, 2523.093418f, 2532.547627f, 2542.010668f, 2551.482524f,
 2560.963179f, 2570.452617f, 2579.950820f, 2589.457774f, 2598.973461f, 2608.497867f, 2618.030975f, 2627.572769f,
 2637.123233f, 2646.682352f, 2656.250110f, 2665.826492f, 2675.411482f, 2685.005064f, 2694.607223f, 2704.217944f,
 2713.837212f, 2723.465012f, 2733.101328f, 2742.746145f, 2752.399449f, 2762.061224f, 2771.731456f, 2781.410129f,
 2791.097231f, 2800.792744f, 2810.496656f, 2820.208951f, 2829.929616f, 2839.658635f, 2849.395994f, 2859.141679f,
 2868.895677f, 2878.657972f, 2888.428550f, 2898.207399f, 2907.994503f, 2917.789849f, 2927.593423f, 2937.405211f,
 2947.225199f, 2957.053374f, 2966.889722f, 2976.734230f, 2986.586884f, 2996.447670f, 3006.316576f, 3016.193588f,
 3026.078692f, 3035.971875f, 3045.873125f, 3055.782428f, 3065.699771f, 3075.625140f, 3085.558524f, 3095.499909f,
 3105.449282f, 3115.406631f, 3125.371943f, 3135.345204f, 3145.326403f, 3155.315526f, 3165.312562f, 3175.317497f,
 3185.330320f, 3195.351017f, 3205.379577f, 3215.415987f, 3225.460235f, 3235.512308f, 3245.572195f, 3255.639884f,
 3265.715361f, 3275.798616f, 3285.889637f, 3295.988410f, 3306.094926f, 3316.209171f, 3326.331133f, 3336.460802f,
 3346.598165f, 3356.743211f, 3366.895929f, 3377.056305f, 3387.224330f, 3397.399991f, 3407.583277f, 3417.774177f,
 3427.972680f, 3438.178773f, 3448.392446f, 3458.613687f, 3468.842486f, 3479.078831f, 3489.322711f, 3499.574115f,
 3509.833032f, 3520.099451f, 3530.373360f, 3540.654750f, 3550.943609f, 3561.239927f, 3571.543692f, 3581.854894f,
 3592.173522f, 3602.499566f, 3612.833015f, 3623.173857f, 3633.522084f, 3643.877683f, 3654.240646f, 3664.610960f,
 3674.988617f, 3685.373604f, 3695.765913f, 3706.165533f, 3716.572453f, 3726.986664f, 3737.408154f, 3747.836915f,
 3758.272936f, 3768.716206f, 3779.166716f, 3789.624455f, 3800.089415f, 3810.561584f, 3821.040953f, 3831.527512f,
 3842.021251f, 3852.522160f, 3863.030230f, 3873.545451f, 3884.067812f, 3894.597305f, 3905.133920f, 3915.677647f,
 3926.228477f, 3936.786399f, 3947.351405f, 3957.923485f, 3968.502630f, 3979.088830f, 3989.682075f, 4000.282357f,
 4010.889666f, 4021.503992f, 4032.125327f, 4042.753661f, 4053.388986f, 4064.031291f, 4074.680568f, 4085.336807f,
 4096.000000f, 4106.670137f, 4117.347210f, 4128.031209f, 4138.722126f, 4149.419951f, 4160.124676f, 4170.836292f,
 4181.554789f, 4192.280159f, 4203.012394f, 4213.751484f, 4224.497421f, 4235.250196f, 4246.009800f, 4256.776225f,
 4267.549462f, 4278.329502f, 4289.116337f, 4299.909959f, 4310.710358f, 4321.517527f, 4332.331456f, 4343.152138f,
 4353.979564f, 4364.813725f, 4375.654614f, 4386.502221f, 4397.356539f, 4408.217559f, 4419.085273f, 4429.959673f,
 4440.840751f, 4451.728498f, 4462.622906f, 4473.523967f, 4484.431673f, 4495.346016f, 4506.266988f, 4517.194581f,
 4528.128786f, 4539.069597f, 4550.017004f, 4560.970999f, 4571.931576f, 4582.898726f, 4593.872441f, 4604.852714f,
 4615.839536f, 4626.832899f, 4637.832797f, 4648.839221f, 4659.852163f, 4670.871616f, 4681.897572f, 4692.930024f,
 4703.968963f, 4715.014383f, 4726.066275f, 4737.124632f, 4748.189446f, 4759.260711f, 4770.338417f, 4781.422559f,
 4792.513128f, 4803.610117f, 4814.713519f, 4825.823326f, 4836.939531f, 4848.062126f, 4859.191105f, 4870.326459f,
 4881.468181f, 4892.616265f, 4903.770703f, 4914.931488f, 4926.098612f, 4937.272069f, 4948.451851f, 4959.637951f,
 4970.830361f, 4982.029076f, 4993.234087f, 5004.445388f, 5015.662972f, 5026.886831f, 5038.116959f, 5049.353348f,
 5060.595992f, 5071.844883f, 5083.100016f, 5094.361382f, 5105.628975f, 5116.902788f, 5128.182814f, 5139.469046f,
 5150.761478f, 5162.060103f, 5173.364914f, 5184.675904f, 5195.993066f, 5207.316394f, 5218.645881f, 5229.981521f,
 5241.323306f, 5252.671230f, 5264.025286f, 5275.385468f, 5286.751770f, 5298.124183f, 5309.502703f, 5320.887323f,
 5332.278035f, 5343.674833f, 5355.077712f, 5366.486664f, 5377.901683f, 5389.322762f, 5400.749896f, 5412.183077f,
 5423.622300f, 5435.067557f, 5446.518843f, 5457.976152f, 5469.439476f, 5480.908810f, 5492.384147f, 5503.865481f,
 5515.352806f, 5526.846116f, 5538.345404f, 5549.850664f, 5561.361890f, 5572.879076f, 5584.402215f, 5595.931301f,
 5607.466329f, 5619.007292f, 5630.554185f, 5642.107000f, 5653.665732f, 5665.230375f, 5676.800923f, 5688.377370f,
 5699.959709f, 5711.547936f, 5723.142043f, 5734.742025f, 5746.347876f, 5757.959590f, 5769.577161f, 5781.200584f,
 5792.829852f, 5804.464959f, 5816.105900f, 5827.752668f, 5839.405259f, 5851.063665f, 5862.727882f, 5874.397904f,
 5886.073724f, 5897.755337f, 5909.442738f, 5921.135920f, 5932.834878f, 5944.539606f, 5956.250098f, 5967.966350f,
 5979.688354f, 5991.416106f, 6003.149600f, 6014.888830f, 6026.633791f, 6038.384476f, 6050.140882f, 6061.903001f,
 6073.670828f, 6085.444359f, 6097.223586f, 6109.008506f, 6120.799112f, 6132.595399f, 6144.397361f, 6156.204993f,
 6168.018289f, 6179.837245f, 6191.661854f, 6203.492112f, 6215.328012f, 6227.169550f, 6239.016720f, 6250.869517f,
 6262.727935f, 6274.591969f, 6286.461614f, 6298.336865f, 6310.217716f, 6322.104162f, 6333.996197f, 6345.893817f,
 6357.797016f, 6369.705789f, 6381.620131f, 6393.540036f, 6405.465500f, 6417.396517f, 6429.333082f, 6441.275190f,
 6453.222835f, 6465.176013f, 6477.134719f, 6489.098947f, 6501.068692f, 6513.043949f, 6525.024714f, 6537.010981f,
 6549.002744f, 6561.000000f, 6573.002743f, 6585.010967f, 6597.024669f, 6609.043842f, 6621.068483f, 6633.098585f,
 6645.134145f, 6657.175157f, 6669.221616f, 6681.273517f, 6693.330855f, 6705.393626f, 6717.461825f, 6729.535446f,
 6741.614485f, 6753.698937f, 6765.788798f, 6777.884061f, 6789.984723f, 6802.090779f, 6814.202223f, 6826.319052f,
 6838.441259f, 6850.568842f, 6862.701794f, 6874.840111f, 6886.983788f, 6899.132821f, 6911.287205f, 6923.446935f,
 6935.612006f, 6947.782414f, 6959.958154f, 6972.139221f, 6984.325611f, 6996.517319f, 7008.714341f, 7020.916672f,
 7033.124306f, 7045.337241f, 7057.555470f, 7069.778990f, 7082.007795f, 7094.241882f, 7106.481246f, 7118.725881f,
 7130.975785f, 7143.230951f, 7155.491376f, 7167.757056f, 7180.027984f, 7192.304158f, 7204.585573f, 7216.872224f,
 7229.164106f, 7241.461216f, 7253.763548f, 7266.071099f, 7278.383864f, 7290.701838f, 7303.025018f, 7315.353398f,
 7327.686975f, 7340.025743f, 7352.369699f, 7364.718839f, 7377.073157f, 7389.432650f, 7401.797314f, 7414.167143f,
 7426.542134f, 7438.922282f, 7451.307583f, 7463.698033f, 7476.093627f, 7488.494362f, 7500.900233f, 7513.311235f,
 7525.727365f, 7538.148618f, 7550.574989f, 7563.006476f, 7575.443073f, 7587.884777f, 7600.331583f, 7612.783487f,
 7625.240485f, 7637.702572f, 7650.169745f, 7662.641999f, 7675.119331f, 7687.601736f, 7700.089209f, 7712.581748f,
 7725.079347f, 7737.582003f, 7750.089712f, 7762.602469f, 7775.120271f, 7787.643113f, 7800.170991f, 7812.703902f,
 7825.241841f, 7837.784804f, 7850.332787f, 7862.885787f, 7875.443798f, 7888.006818f, 7900.574842f, 7913.147866f,
 7925.725887f, 7938.308900f, 7950.896901f, 7963.489886f, 7976.087852f, 7988.690794f, 8001.298709f, 8013.911593f,
 8026.529441f, 8039.152250f, 8051.780016f, 8064.412735f, 8077.050403f, 8089.693017f, 8102.340572f, 8114.993064f,
 8127.650490f, 8140.312846f, 8152.980128f, 8165.652333f, 8178.329455f, 8191.011492f, 8203.698440f, 8216.390295f,
 8229.087053f, 8241.788711f, 8254.495264f, 8267.206709f, 8279.923042f, 8292.644259f, 8305.370357f, 8318.101332f,
 8330.837180f, 8343.577897f, 8356.323480f, 8369.073925f, 8381.829228f, 8394.589385f, 8407.354394f, 8420.124249f,
 8432.898948f, 8445.678487f, 8458.462862f, 8471.252070f, 8484.046106f, 8496.844968f, 8509.648651f, 8522.457152f,
 8535.270468f, 8548.088594f, 8560.911527f, 8573.739264f, 8586.571801f, 8599.409134f, 8612.251259f, 8625.098174f,
 8637.949875f, 8650.806357f, 8663.667618f, 8676.533654f, 8689.404461f, 8702.280037f, 8715.160376f, 8728.045476f,
 8740.935334f, 8753.829945f, 8766.729307f, 8779.633415f, 8792.542267f, 8805.455858f, 8818.374186f, 8831.297247f,
 8844.225037f, 8857.157553f, 8870.094791f, 8883.036748f, 8895.983421f, 8908.934807f, 8921.890901f, 8934.851700f,
 8947.817201f, 8960.787401f, 8973.762296f, 8986.741882f, 8999.726157f, 9012.715117f, 9025.708758f, 9038.707077f,
 9051.710072f, 9064.717737f, 9077.730071f, 9090.747070f, 9103.768730f, 9116.795048f, 9129.826021f, 9142.861645f,
 9155.901917f, 9168.946835f, 9181.996393f, 9195.050590f, 9208.109422f, 9221.172885f, 9234.240977f, 9247.313694f,
 9260.391032f, 9273.472989f, 9286.559562f, 9299.650746f, 9312.746539f, 9325.846938f, 9338.951939f, 9352.061539f,
 9365.175734f, 9378.294523f, 9391.417901f, 9404.545865f, 9417.678412f, 9430.815538f, 9443.957242f, 9457.103518f,
 9470.254365f, 9483.409779f, 9496.569757f, 9509.734296f, 9522.903392f, 9536.077043f, 9549.255245f, 9562.437995f,
 9575.625290f, 9588.817127f, 9602.013503f, 9615.214414f, 9628.419858f, 9641.629831f, 9654.844330f, 9668.063353f,
 9681.286896f, 9694.514956f, 9707.747529f, 9720.984614f, 9734.226206f, 9747.472303f, 9760.722902f, 9773.977999f,
 9787.237592f, 9800.501677f, 9813.770252f, 9827.043313f, 9840.320858f, 9853.602883f, 9866.889385f, 9880.180361f,
 9893.475809f, 9906.775725f, 9920.080107f, 9933.388951f, 9946.702254f, 9960.020013f, 9973.342226f, 9986.668889f,
10000.000000f,10013.335555f,10026.675552f,10040.019987f,10053.368857f,10066.722161f,10080.079894f,10093.442053f,
10106.808637f,10120.179641f,10133.555064f,10146.934901f,10160.319151f,10173.707810f,10187.100875f,10200.498344f,
10213.900213f,10227.306480f,10240.717141f,10254.132195f,10267.551637f,10280.975466f,10294.403678f,10307.836271f,
10321.273241f,10334.714585f,10348.160302f,10361.610388f,10375.064840f,10388.523655f,10401.986831f,10415.454364f,
10428.926253f,10442.402493f,10455.883083f,10469.368019f,10482.857299f,10496.350920f,10509.848879f,10523.351173f,
10536.857800f,10550.368756f,10563.884040f,10577.403647f,10590.927576f,10604.455824f,10617.988388f,10631.525264f,
10645.066452f,10658.611947f,10672.161747f,10685.715849f,10699.274250f,10712.836948f,10726.403941f,10739.975224f,
10753.550797f,10767.130655f,10780.714796f,10794.303218f,10807.895918f,10821.492892f,10835.094140f,10848.699656f,
10862.309440f,10875.923489f,10889.541799f,10903.164368f,10916.791193f,10930.422273f,10944.057603f,10957.697182f,
10971.341006f,10984.989074f,10998.641382f,11012.297928f,11025.958709f,11039.623723f,11053.292967f,11066.966438f,
11080.644134f,11094.326053f,11108.012190f,11121.702545f,11135.397114f,11149.095895f,11162.798885f,11176.506082f,
11190.217483f,11203.933085f,11217.652886f,11231.376883f,11245.105074f,11258.837456f,11272.574027f,11286.314784f,
11300.059724f,11313.808845f,11327.562145f,11341.319621f,11355.081270f,11368.847090f,11382.617078f,11396.391232f,
11410.169549f,11423.952027f,11437.738663f,11451.529455f,11465.324400f,11479.123496f,11492.926740f,11506.734130f,
11520.545663f,11534.361337f,11548.181149f,11562.005097f,11575.833179f,11589.665391f,11603.501732f,11617.342198f,
11631.186788f,11645.035499f,11658.888329f,11672.745275f,11686.606334f,11700.471505f,11714.340784f,11728.214170f,
11742.091660f,11755.973251f,11769.858942f,11783.748729f,11797.642610f,11811.540583f,11825.442646f,11839.348796f,
11853.259030f,11867.173346f,11881.091743f,11895.014217f,11908.940766f,11922.871387f,11936.806079f,11950.744839f,
11964.687665f,11978.634553f,11992.585503f,12006.540511f,12020.499575f,12034.462692f,12048.429861f,12062.401080f,
12076.376344f,12090.355654f,12104.339005f,12118.326396f,12132.317824f,12146.313287f,12160.312783f,12174.316310f,
12188.323864f,12202.335444f,12216.351048f,12230.370673f,12244.394316f,12258.421976f,12272.453650f,12286.489336f,
12300.529032f,12314.572735f,12328.620443f,12342.672154f,12356.727866f,12370.787575f,12384.851281f,12398.918980f,
12412.990671f,12427.066350f,12441.146017f,12455.229668f,12469.317302f,12483.408916f,12497.504507f,12511.604075f,
12525.707615f,12539.815127f,12553.926608f,12568.042055f,12582.161467f,12596.284841f,12610.412175f,12624.543467f,
12638.678715f,12652.817915f,12666.961067f,12681.108168f,12695.259216f,12709.414208f,12723.573143f,12737.736017f,
12751.902830f,12766.073579f,12780.248261f,12794.426874f,12808.609417f,12822.795886f,12836.986281f,12851.180598f,
12865.378836f,12879.580992f,12893.787065f,12907.997051f,12922.210950f,12936.428758f,12950.650474f,12964.876095f,
12979.105619f,12993.339045f,13007.576370f,13021.817591f,13036.062708f,13050.311717f,13064.564616f,13078.821404f,
13093.082079f,13107.346637f,13121.615077f,13135.887398f,13150.163596f,13164.443670f,13178.727617f,13193.015436f,
13207.307125f,13221.602680f,13235.902101f,13250.205385f,13264.512531f,13278.823535f,13293.138396f,13307.457112f,
13321.779680f,13336.106100f,13350.436367f,13364.770482f,13379.108441f,13393.450242f,13407.795884f,13422.145364f,
13436.498680f,13450.855830f,13465.216813f,13479.581625f,13493.950266f,13508.322733f,13522.699023f,13537.079136f,
13551.463069f,13565.850819f,13580.242386f,13594.637766f,13609.036958f,13623.439960f,13637.846770f,13652.257385f,
13666.671804f,13681.090025f,13695.512046f,13709.937865f,13724.367479f,13738.800887f,13753.238087f,13767.679077f,
13782.123854f,13796.572417f,13811.024764f,13825.480893f,13839.940802f,13854.404489f,13868.871952f,13883.343188f,
13897.818197f,13912.296976f,13926.779522f,13941.265835f,13955.755912f,13970.249751f,13984.747351f,13999.248708f,
14013.753822f,14028.262691f,14042.775312f,14057.291683f,14071.811803f,14086.335669f,14100.863281f,14115.394635f,
14129.929730f,14144.468564f,14159.011135f,14173.557441f,14188.107480f,14202.661250f,14217.218750f,14231.779977f,
14246.344930f,14260.913606f,14275.486004f,14290.062122f,14304.641958f,14319.225510f,14333.812776f,14348.403754f,
14362.998443f,14377.596840f,14392.198943f,14406.804752f,14421.414263f,14436.027475f,14450.644386f,14465.264995f,
14479.889298f,14494.517296f,14509.148984f,14523.784363f,14538.423430f,14553.066182f,14567.712619f,14582.362738f,
14597.016537f,14611.674015f,14626.335170f,14641.000000f,14655.668503f,14670.340677f,14685.016521f,14699.696032f,
14714.379209f,14729.066050f,14743.756553f,14758.450716f,14773.148537f,14787.850016f,14802.555149f,14817.263935f,
14831.976372f,14846.692459f,14861.412193f,14876.135573f,14890.862597f,14905.593263f,14920.327569f,14935.065514f,
14949.807096f,14964.552313f,14979.301163f,14994.053644f,15008.809755f,15023.569493f,15038.332858f,15053.099847f,
15067.870458f,15082.644690f,15097.422541f,15112.204010f,15126.989093f,15141.777790f,15156.570099f,15171.366018f,
15186.165546f,15200.968679f,15215.775418f,15230.585760f,15245.399703f,15260.217246f,15275.038386f,15289.863123f,
15304.691453f,15319.523377f,15334.358891f,15349.197994f,15364.040685f,15378.886961f,15393.736821f,15408.590264f,
15423.447287f,15438.307888f,15453.172066f,15468.039820f,15482.911147f,15497.786047f,15512.664516f,15527.546554f,
15542.432158f,15557.321327f,15572.214060f,15587.110354f,15602.010208f,15616.913620f,15631.820589f,15646.731113f,
15661.645189f,15676.562817f,15691.483995f,15706.408720f,15721.336992f,15736.268809f,15751.204169f,15766.143070f,
15781.085510f,15796.031489f,15810.981003f,15825.934053f,15840.890635f,15855.850748f,15870.814391f,15885.781562f,
15900.752259f,15915.726481f,15930.704226f,15945.685492f,15960.670277f,15975.658581f,15990.650401f,16005.645735f,
16020.644583f,16035.646942f,16050.652811f,16065.662188f,16080.675071f,16095.691459f,16110.711350f,16125.734743f,
16140.761636f,16155.792027f,16170.825914f,16185.863297f,16200.904173f,16215.948541f,16230.996399f,16246.047745f,
16261.102579f,16276.160898f,16291.222700f,16306.287985f,16321.356750f,16336.428994f,16351.504716f,16366.583913f,
16381.666584f,16396.752727f,16411.842341f,16426.935425f,16442.031976f,16457.131994f,16472.235476f,16487.342421f,
16502.452827f,16517.566693f,16532.684017f,16547.804797f,16562.929033f,16578.056722f,16593.187863f,16608.322454f,
16623.460494f,16638.601981f,16653.746913f,16668.895290f,16684.047109f,16699.202368f,16714.361068f,16729.523204f,
16744.688777f,16759.857785f,16775.030226f,16790.206098f,16805.385400f,16820.568131f,16835.754288f,16850.943871f,
16866.136877f,16881.333306f,16896.533155f,16911.736424f,16926.943110f,16942.153213f,16957.366730f,16972.583659f,
16987.804001f,17003.027752f,17018.254912f,17033.485478f,17048.719451f,17063.956826f,17079.197605f,17094.441784f,
17109.689362f,17124.940338f,17140.194711f,17155.452478f,17170.713638f,17185.978190f,17201.246133f,17216.517464f,
17231.792182f,17247.070287f,17262.351775f,17277.636646f,17292.924898f,17308.216530f,17323.511541f,17338.809928f,
17354.111690f,17369.416826f,17384.725335f,17400.037214f,17415.352462f,17430.671079f,17445.993061f,17461.318409f,
17476.647120f,17491.979193f,17507.314626f,17522.653419f,17537.995569f,17553.341074f,17568.689935f,17584.042149f,
17599.397714f,17614.756629f,17630.118893f,17645.484505f,17660.853462f,17676.225764f,17691.601408f,17706.980394f,
17722.362720f,17737.748384f,17753.137386f,17768.529723f,17783.925394f,17799.324399f,17814.726734f,17830.132399f,
17845.541393f,17860.953714f,17876.369360f,17891.788331f,17907.210624f,17922.636238f,17938.065173f,17953.497425f,
17968.932995f,17984.371880f,17999.814079f,18015.259591f,18030.708415f,18046.160548f,18061.615990f,18077.074738f,
18092.536793f,18108.002151f,18123.470812f,18138.942775f,18154.418038f,18169.896599f,18185.378458f,18200.863612f,
18216.352060f,18231.843802f,18247.338835f,18262.837158f,18278.338770f,18293.843670f,18309.351855f,18324.863325f,
18340.378078f,18355.896113f,18371.417429f,18386.942023f,18402.469895f,18418.001044f,18433.535467f,18449.073164f,
18464.614132f,18480.158372f,18495.705881f,18511.256658f,18526.810702f,18542.368011f,18557.928583f,18573.492419f,
18589.059515f,18604.629871f,18620.203486f,18635.780358f,18651.360485f,18666.943867f,18682.530502f,18698.120388f,
18713.713525f,18729.309910f,18744.909543f,18760.512422f,18776.118546f,18791.727914f,18807.340524f,18822.956374f,
18838.575464f,18854.197793f,18869.823358f,18885.452158f,18901.084193f,18916.719460f,18932.357958f,18947.999687f,
18963.644645f,18979.292830f,18994.944241f,19010.598877f,19026.256736f,19041.917817f,19057.582120f,19073.249641f,
19088.920381f,19104.594338f,19120.271510f,19135.951896f,19151.635495f,19167.322306f,19183.012327f,19198.705557f,
19214.401994f,19230.101638f,19245.804487f,19261.510539f,19277.219794f,19292.932250f,19308.647906f,19324.366760f,
19340.088811f,19355.814058f,19371.542500f,19387.274135f,19403.008962f,19418.746980f,19434.488187f,19450.232582f,
19465.980164f,19481.730931f,19497.484883f,19513.242017f,19529.002334f,19544.765830f,19560.532506f,19576.302359f,
19592.075389f,19607.851595f,19623.630974f,19639.413526f,19655.199249f,19670.988143f,19686.780205f,19702.575435f,
19718.373831f,19734.175393f,19749.980118f,19765.788005f,19781.599054f,19797.413263f,19813.230631f,19829.051156f,
19844.874837f,19860.701674f,19876.531664f,19892.364806f,19908.201100f,19924.040543f,19939.883136f,19955.728875f,
19971.577761f,19987.429792f,20003.284967f,20019.143283f,20035.004742f,20050.869340f,20066.737076f,20082.607951f,
20098.481961f,20114.359107f,20130.239386f,20146.122797f,20162.009340f,20177.899014f,20193.791815f,20209.687745f,
20225.586801f,20241.488982f,20257.394286f,20273.302714f,20289.214263f,20305.128932f,20321.046720f,20336.967626f,
20352.891648f,20368.818786f,20384.749038f,20400.682403f,20416.618879f,20432.558466f,20448.501162f,20464.446967f,
20480.395878f,20496.347894f,20512.303016f,20528.261240f,20544.222566f,20560.186993f,20576.154520f,20592.125145f,
20608.098867f,20624.075685f,20640.055598f,20656.038605f,20672.024704f,20688.013894f,20704.006174f,20720.001543f,
20736.000000f,20752.001543f,20768.006171f,20784.013883f,20800.024679f,20816.038555f,20832.055513f,20848.075549f,
20864.098664f,20880.124856f,20896.154123f,20912.186465f,20928.221880f,20944.260368f,20960.301926f,20976.346555f,
20992.394252f,21008.445017f,21024.498848f,21040.555744f,21056.615704f,21072.678727f,21088.744811f,21104.813957f,
21120.886161f,21136.961424f,21153.039743f,21169.121119f,21185.205549f,21201.293033f,21217.383569f,21233.477156f,
21249.573793f,21265.673480f,21281.776214f,21297.881994f,21313.990820f,21330.102690f,21346.217604f,21362.335559f,
21378.456555f,21394.580591f,21410.707666f,21426.837778f,21442.970926f,21459.107109f,21475.246326f,21491.388576f,
21507.533858f,21523.682170f,21539.833512f,21555.987882f,21572.145279f,21588.305702f,21604.469150f,21620.635622f,
21636.805116f,21652.977632f,21669.153168f,21685.331724f,21701.513297f,21717.697888f,21733.885494f,21750.076116f,
21766.269750f,21782.466398f,21798.666056f,21814.868725f,21831.074403f,21847.283089f,21863.494782f,21879.709481f,
21895.927184f,21912.147891f,21928.371600f,21944.598311f,21960.828022f,21977.060732f,21993.296440f,22009.535145f,
22025.776846f,22042.021541f,22058.269230f,22074.519912f,22090.773584f,22107.030248f,22123.289900f,22139.552540f,
22155.818168f,22172.086781f,22188.358379f,22204.632961f,22220.910525f,22237.191071f,22253.474598f,22269.761103f,
22286.050587f,22302.343048f,22318.638485f,22334.936897f,22351.238283f,22367.542642f,22383.849973f,22400.160274f,
22416.473544f,22432.789784f,22449.108990f,22465.431163f,22481.756301f,22498.084404f,22514.415469f,22530.749496f,
22547.086485f,22563.426433f,22579.769340f,22596.115205f,22612.464026f,22628.815803f,22645.170535f,22661.528220f,
22677.888857f,22694.252446f,22710.618984f,22726.988473f,22743.360909f,22759.736292f,22776.114621f,22792.495896f,
22808.880114f,22825.267275f,22841.657378f,22858.050421f,22874.446404f,22890.845326f,22907.247185f,22923.651981f,
22940.059712f,22956.470378f,22972.883977f,22989.300508f,23005.719971f,23022.142364f,23038.567686f,23054.995936f,
23071.427113f,23087.861216f,23104.298245f,23120.738197f,23137.181072f,23153.626869f,23170.075587f,23186.527224f,
23202.981781f,23219.439255f,23235.899646f,23252.362952f,23268.829173f,23285.298308f,23301.770355f,23318.245314f,
23334.723184f,23351.203963f,23367.687650f,23384.174245f,23400.663746f,23417.156152f,23433.651463f,23450.149677f,
23466.650794f,23483.154812f,23499.661730f,23516.171547f,23532.684263f,23549.199876f,23565.718385f,23582.239789f,
23598.764087f,23615.291279f,23631.821363f,23648.354338f,23664.890203f,23681.428957f,23697.970599f,23714.515128f,
23731.062544f,23747.612844f,23764.166029f,23780.722096f,23797.281046f,23813.842877f,23830.407588f,23846.975178f,
23863.545646f,23880.118991f,23896.695212f,23913.274308f,23929.856278f,23946.441122f,23963.028837f,23979.619424f,
23996.212880f,24012.809206f,24029.408400f,24046.010461f,24062.615388f,24079.223180f,24095.833837f,24112.447356f,
24129.063738f,24145.682981f,24162.305084f,24178.930046f,24195.557867f,24212.188545f,24228.822079f,24245.458468f,
24262.097712f,24278.739809f,24295.384759f,24312.032559f,24328.683211f,24345.336711f,24361.993060f,24378.652257f,
24395.314300f,24411.979189f,24428.646922f,24445.317499f,24461.990918f,24478.667179f,24495.346281f,24512.028223f,
24528.713003f,24545.400621f,24562.091076f,24578.784367f,24595.480492f,24612.179452f,24628.881244f,24645.585869f,
24662.293325f,24679.003610f,24695.716725f,24712.432668f,24729.151438f,24745.873035f,24762.597457f,24779.324703f,
24796.054772f,24812.787664f,24829.523378f,24846.261912f,24863.003266f,24879.747438f,24896.494428f,24913.244235f,
24929.996857f,24946.752295f,24963.510546f,24980.271610f,24997.035487f,25013.802174f,25030.571672f,25047.343978f,
25064.119093f,25080.897016f,25097.677744f,25114.461278f,25131.247617f,25148.036759f,25164.828704f,25181.623451f,
25198.420998f,25215.221345f,25232.024491f,25248.830435f,25265.639176f,25282.450713f,25299.265045f,25316.082172f,
25332.902091f,25349.724804f,25366.550307f,25383.378601f,25400.209685f,25417.043558f,25433.880218f,25450.719665f,
25467.561898f,25484.406916f,25501.254718f,25518.105303f,25534.958670f,25551.814819f,25568.673748f,25585.535457f,
25602.399944f,25619.267208f,25636.137250f,25653.010067f,25669.885660f,25686.764026f,25703.645165f,25720.529077f,
25737.415759f,25754.305213f,25771.197435f,25788.092426f,25804.990185f,25821.890710f,25838.794002f,25855.700058f,
25872.608878f,25889.520461f,25906.434807f,25923.351913f,25940.271781f,25957.194407f,25974.119793f,25991.047936f,
26007.978835f,26024.912491f,26041.848902f,26058.788067f,26075.729985f,26092.674655f,26109.622077f,26126.572249f,
26143.525171f,26160.480842f,26177.439260f,26194.400426f,26211.364337f,26228.330994f,26245.300395f,26262.272540f,
26279.247427f,26296.225056f,26313.205425f,26330.188534f,26347.174383f,26364.162969f,26381.154293f,26398.148353f,
26415.145148f,26432.144678f,26449.146942f,26466.151939f,26483.159667f,26500.170127f,26517.183317f,26534.199236f,
26551.217883f,26568.239258f,26585.263360f,26602.290188f,26619.319740f,26636.352017f,26653.387017f,26670.424739f,
26687.465183f,26704.508347f,26721.554231f,26738.602834f,26755.654154f,26772.708192f,26789.764946f,26806.824416f,
26823.886600f,26840.951498f,26858.019109f,26875.089431f,26892.162465f,26909.238209f,26926.316662f,26943.397823f,
26960.481693f,26977.568269f,26994.657551f,27011.749538f,27028.844229f,27045.941624f,27063.041721f,27080.144520f,
27097.250020f,27114.358219f,27131.469118f,27148.582715f,27165.699009f,27182.818000f,27199.939687f,27217.064068f,
27234.191143f,27251.320912f,27268.453373f,27285.588525f,27302.726368f,27319.866901f,27337.010122f,27354.156032f,
27371.304629f,27388.455912f,27405.609881f,27422.766535f,27439.925872f,27457.087892f,27474.252595f,27491.419979f,
27508.590044f,27525.762788f,27542.938211f,27560.116312f,27577.297090f,27594.480545f,27611.666675f,27628.855480f,
27646.046958f,27663.241110f,27680.437934f,27697.637429f,27714.839595f,27732.044430f,27749.251934f,27766.462107f,
27783.674946f,27800.890452f,27818.108624f,27835.329460f,27852.552960f,27869.779123f,27887.007948f,27904.239435f,
27921.473583f,27938.710390f,27955.949856f,27973.191981f,27990.436762f,28007.684201f,28024.934295f,28042.187044f,
28059.442446f,28076.700503f,28093.961211f,28111.224571f,28128.490582f,28145.759243f,28163.030554f,28180.304512f,
28197.581118f,28214.860371f,28232.142270f,28249.426814f,28266.714002f,28284.003834f,28301.296308f,28318.591424f,
28335.889182f,28353.189579f,28370.492617f,28387.798292f,28405.106606f,28422.417557f,28439.731144f,28457.047366f,
28474.366223f,28491.687714f,28509.011838f,28526.338594f,28543.667982f,28561.000000f,28578.334648f,28595.671925f,
28613.011831f,28630.354364f,28647.699523f,28665.047309f,28682.397719f,28699.750754f,28717.106412f,28734.464693f,
28751.825596f,28769.189120f,28786.555264f,28803.924028f,28821.295410f,28838.669411f,28856.046028f,28873.425262f,
28890.807112f,28908.191576f,28925.578655f,28942.968346f,28960.360650f,28977.755566f,28995.153093f,29012.553229f,
29029.955975f,29047.361330f,29064.769292f,29082.179861f,29099.593036f,29117.008817f,29134.427203f,29151.848192f,
29169.271784f,29186.697979f,29204.126775f,29221.558171f,29238.992168f,29256.428764f,29273.867958f,29291.309750f,
29308.754139f,29326.201124f,29343.650704f,29361.102879f,29378.557648f,29396.015009f,29413.474963f,29430.937508f,
29448.402644f,29465.870370f,29483.340685f,29500.813588f,29518.289079f,29535.767157f,29553.247821f,29570.731070f,
29588.216904f,29605.705322f,29623.196322f,29640.689905f,29658.186069f,29675.684815f,29693.186140f,29710.690044f,
29728.196527f,29745.705587f,29763.217225f,29780.731439f,29798.248228f,29815.767591f,29833.289529f,29850.814040f,
29868.341123f,29885.870778f,29903.403004f,29920.937800f,29938.475165f,29956.015099f,29973.557601f,29991.102670f,
30008.650305f,30026.200506f,30043.753272f,30061.308602f,30078.866496f,30096.426952f,30113.989970f,30131.555549f,
30149.123688f,30166.694387f,30184.267645f,30201.843461f,30219.421835f,30237.002765f,30254.586251f,30272.172293f,
30289.760889f,30307.352038f,30324.945740f,30342.541995f,30360.140801f,30377.742158f,30395.346065f,30412.952521f,
30430.561526f,30448.173078f,30465.787178f,30483.403823f,30501.023015f,30518.644751f,30536.269031f,30553.895855f,
30571.525221f,30589.157129f,30606.791579f,30624.428569f,30642.068098f,30659.710167f,30677.354773f,30695.001918f,
30712.651599f,30730.303816f,30747.958568f,30765.615855f,30783.275676f,30800.938030f,30818.602917f,30836.270335f,
30853.940284f,30871.612763f,30889.287772f,30906.965310f,30924.645376f,30942.327969f,30960.013089f,30977.700734f,
30995.390905f,31013.083600f,31030.778819f,31048.476561f,31066.176826f,31083.879612f,31101.584918f,31119.292745f,
31137.003092f,31154.715957f,31172.431340f,31190.149240f,31207.869657f,31225.592590f,31243.318038f,31261.046000f,
31278.776476f,31296.509465f,31314.244967f,31331.982980f,31349.723504f,31367.466538f,31385.212081f,31402.960133f,
31420.710693f,31438.463761f,31456.219335f,31473.977415f,31491.738000f,31509.501090f,31527.266683f,31545.034780f,
31562.805379f,31580.578479f,31598.354081f,31616.132183f,31633.912784f,31651.695884f,31669.481483f,31687.269578f,
31705.060171f,31722.853260f,31740.648844f,31758.446922f,31776.247495f,31794.050561f,31811.856119f,31829.664169f,
31847.474711f,31865.287743f,31883.103264f,31900.921275f,31918.741774f,31936.564761f,31954.390235f,31972.218195f,
31990.048640f,32007.881571f,32025.716986f,32043.554884f,32061.395265f,32079.238128f,32097.083473f,32114.931298f,
32132.781604f,32150.634389f,32168.489652f,32186.347394f,32204.207613f,32222.070308f,32239.935480f,32257.803127f,
32275.673248f,32293.545843f,32311.420912f,32329.298453f,32347.178465f,32365.060949f,32382.945904f,32400.833328f,
32418.723221f,32436.615583f,32454.510412f,32472.407709f,32490.307472f,32508.209700f,32526.114394f,32544.021552f,
32561.931173f,32579.843258f,32597.757805f,32615.674814f,32633.594283f,32651.516213f,32669.440602f,32687.367451f,
32705.296757f,32723.228521f,32741.162743f,32759.099420f,32777.038553f,32794.980141f,32812.924183f,32830.870678f,
32848.819627f,32866.771027f,32884.724879f,32902.681182f,32920.639936f,32938.601139f,32956.564790f,32974.530890f,
32992.499437f,33010.470432f,33028.443872f,33046.419758f,33064.398089f,33082.378864f,33100.362083f,33118.347744f,
33136.335848f,33154.326393f,33172.319379f,33190.314805f,33208.312671f,33226.312976f,33244.315719f,33262.320900f,
33280.328517f,33298.338571f,33316.351061f,33334.365985f,33352.383344f,33370.403136f,33388.425361f,33406.450019f,
33424.477108f,33442.506628f,33460.538578f,33478.572959f,33496.609768f,33514.649006f,33532.690671f,33550.734763f,
33568.781282f,33586.830227f,33604.881597f,33622.935391f,33640.991609f,33659.050250f,33677.111314f,33695.174800f,
33713.240706f,33731.309034f,33749.379781f,33767.452948f,33785.528533f,33803.606536f,33821.686957f,33839.769794f,
33857.855047f,33875.942716f,33894.032799f,33912.125296f,33930.220207f,33948.317531f,33966.417267f,33984.519414f,
34002.623973f,34020.730941f,34038.840320f,34056.952107f,34075.066302f,34093.182905f,34111.301916f,34129.423332f,
34147.547154f,34165.673382f,34183.802014f,34201.933050f,34220.066489f,34238.202330f,34256.340574f,34274.481219f,
34292.624264f,34310.769710f,34328.917555f,34347.067799f,34365.220440f,34383.375480f,34401.532916f,34419.692748f,
34437.854976f,34456.019599f,34474.186617f,34492.356028f,34510.527832f,34528.702028f,34546.878617f,34565.057596f,
34583.238966f,34601.422726f,34619.608876f,34637.797414f,34655.988340f,34674.181653f,34692.377354f,34710.575440f,
34728.775912f,34746.978769f,34765.184010f,34783.391635f,34801.601643f,34819.814033f,34838.028805f,34856.245958f,
34874.465492f,34892.687406f,34910.911699f,34929.138371f,34947.367420f,34965.598848f,34983.832652f,35002.068832f,
35020.307388f,35038.548319f,35056.791624f,35075.037303f,35093.285355f,35111.535779f,35129.788576f,35148.043743f,
35166.301282f,35184.561190f,35202.823468f,35221.088114f,35239.355129f,35257.624511f,35275.896260f,35294.170376f,
35312.446857f,35330.725704f,35349.006915f,35367.290490f,35385.576428f,35403.864729f,35422.155392f,35440.448416f,
35458.743801f,35477.041547f,35495.341652f,35513.644116f,35531.948938f,35550.256119f,35568.565656f,35586.877550f,
35605.191800f,35623.508406f,35641.827366f,35660.148680f,35678.472348f,35696.798369f,35715.126743f,35733.457468f,
35751.790544f,35770.125971f,35788.463747f,35806.803873f,35825.146348f,35843.491171f,35861.838341f,35880.187859f,
35898.539722f,35916.893932f,35935.250486f,35953.609386f,35971.970629f,35990.334215f,36008.700144f,36027.068415f,
36045.439028f,36063.811982f,36082.187276f,36100.564910f,36118.944883f,36137.327195f,36155.711844f,36174.098831f,
36192.488155f,36210.879815f,36229.273810f,36247.670141f,36266.068806f,36284.469805f,36302.873137f,36321.278801f,
36339.686798f,36358.097126f,36376.509785f,36394.924774f,36413.342093f,36431.761742f,36450.183718f,36468.608023f,
36487.034654f,36505.463613f,36523.894898f,36542.328508f,36560.764443f,36579.202703f,36597.643286f,36616.086193f,
36634.531422f,36652.978974f,36671.428846f,36689.881040f,36708.335554f,36726.792388f,36745.251541f,36763.713012f,
36782.176802f,36800.642908f,36819.111332f,36837.582072f,36856.055127f,36874.530498f,36893.008183f,36911.488182f,
36929.970494f,36948.455119f,36966.942056f,36985.431305f,37003.922865f,37022.416735f,37040.912915f,37059.411404f,
37077.912202f,37096.415309f,37114.920722f,37133.428443f,37151.938470f,37170.450803f,37188.965441f,37207.482384f,
37226.001631f,37244.523181f,37263.047035f,37281.573191f,37300.101648f,37318.632407f,37337.165467f,37355.700827f,
37374.238486f,37392.778444f,37411.320700f,37429.865255f,37448.412106f,37466.961255f,37485.512699f,37504.066439f,
37522.622474f,37541.180803f,37559.741427f,37578.304343f,37596.869552f,37615.437053f,37634.006846f,37652.578930f,
37671.153305f,37689.729969f,37708.308922f,37726.890165f,37745.473695f,37764.059513f,37782.647618f,37801.238010f,
37819.830688f,37838.425651f,37857.022899f,37875.622431f,37894.224246f,37912.828345f,37931.434727f,37950.043390f,
37968.654335f,37987.267561f,38005.883067f,38024.500853f,38043.120918f,38061.743262f,38080.367884f,38098.994783f,
38117.623960f,38136.255413f,38154.889141f,38173.525145f,38192.163424f,38210.803977f,38229.446804f,38248.091904f,
38266.739276f,38285.388920f,38304.040836f,38322.695023f,38341.351480f,38360.010206f,38378.671202f,38397.334467f,
38416.000000f,38434.667800f,38453.337868f,38472.010202f,38490.684801f,38509.361666f,38528.040796f,38546.722191f,
38565.405849f,38584.091770f,38602.779954f,38621.470399f,38640.163107f,38658.858075f,38677.555304f,38696.254793f,
38714.956541f,38733.660548f,38752.366813f,38771.075336f,38789.786116f,38808.499152f,38827.214445f,38845.931993f,
38864.651796f,38883.373854f,38902.098166f,38920.824731f,38939.553548f,38958.284618f,38977.017940f,38995.753513f,
39014.491337f,39033.231410f,39051.973734f,39070.718306f,39089.465127f,39108.214196f,39126.965512f,39145.719075f,
39164.474884f,39183.232940f,39201.993240f,39220.755785f,39239.520575f,39258.287608f,39277.056884f,39295.828403f,
39314.602164f,39333.378166f,39352.156409f,39370.936893f,39389.719617f,39408.504580f,39427.291781f,39446.081222f,
39464.872899f,39483.666815f,39502.462966f,39521.261354f,39540.061978f,39558.864837f,39577.669930f,39596.477258f,
39615.286819f,39634.098613f,39652.912639f,39671.728897f,39690.547387f,39709.368107f,39728.191058f,39747.016239f,
39765.843649f,39784.673288f,39803.505155f,39822.339249f,39841.175571f,39860.014120f,39878.854894f,39897.697895f,
39916.543120f,39935.390570f,39954.240244f,39973.092141f,39991.946261f,40010.802604f,40029.661169f,40048.521955f,
40067.384962f,40086.250189f,40105.117636f,40123.987302f,40142.859188f,40161.733291f,40180.609612f,40199.488151f,
40218.368906f,40237.251877f,40256.137064f,40275.024467f,40293.914083f,40312.805914f,40331.699959f,40350.596216f,
40369.494686f,40388.395368f,40407.298262f,40426.203366f,40445.110682f,40464.020207f,40482.931941f,40501.845884f,
40520.762036f,40539.680396f,40558.600963f,40577.523737f,40596.448717f,40615.375904f,40634.305295f,40653.236891f,
40672.170692f,40691.106696f,40710.044904f,40728.985314f,40747.927927f,40766.872741f,40785.819757f,40804.768973f,
40823.720390f,40842.674006f,40861.629821f,40880.587835f,40899.548047f,40918.510457f,40937.475064f,40956.441868f,
40975.410868f,40994.382063f,41013.355453f,41032.331038f,41051.308818f,41070.288790f,41089.270956f,41108.255314f,
41127.241865f,41146.230607f,41165.221540f,41184.214664f,41203.209977f,41222.207480f,41241.207172f,41260.209053f,
41279.213122f,41298.219378f,41317.227821f,41336.238451f,41355.251267f,41374.266268f,41393.283455f,41412.302825f,
41431.324380f,41450.348119f,41469.374040f,41488.402144f,41507.432429f,41526.464897f,41545.499545f,41564.536374f,
41583.575383f,41602.616571f,41621.659938f,41640.705484f,41659.753208f,41678.803109f,41697.855187f,41716.909442f,
41735.965873f,41755.024479f,41774.085261f,41793.148217f,41812.213346f,41831.280650f,41850.350126f,41869.421775f,
41888.495596f,41907.571589f,41926.649753f,41945.730087f,41964.812591f,41983.897265f,42002.984108f,42022.073120f,
42041.164299f,42060.257647f,42079.353161f,42098.450842f,42117.550689f,42136.652702f,42155.756880f,42174.863222f,
42193.971729f,42213.082399f,42232.195233f,42251.310229f,42270.427388f,42289.546708f,42308.668189f,42327.791832f,
42346.917634f,42366.045596f,42385.175718f,42404.307998f,42423.442437f,42442.579033f,42461.717787f,42480.858697f,
42500.001764f,42519.146987f,42538.294365f,42557.443898f,42576.595586f,42595.749427f,42614.905422f,42634.063570f,
42653.223870f,42672.386322f,42691.550926f,42710.717681f,42729.886587f,42749.057642f,42768.230847f,42787.406201f,
42806.583704f,42825.763355f,42844.945154f,42864.129099f,42883.315192f,42902.503430f,42921.693815f,42940.886344f,
42960.081019f,42979.277838f,42998.476800f,43017.677906f,43036.881155f,43056.086546f,43075.294079f,43094.503753f,
43113.715569f,43132.929525f,43152.145621f,43171.363856f,43190.584230f,43209.806743f,43229.031395f,43248.258183f,
43267.487109f,43286.718172f,43305.951370f,43325.186705f,43344.424174f,43363.663779f,43382.905518f,43402.149390f,
43421.395396f,43440.643535f,43459.893806f,43479.146209f,43498.400744f,43517.657409f,43536.916205f,43556.177132f,
43575.440187f,43594.705372f,43613.972686f,43633.242127f,43652.513696f,43671.787393f,43691.063216f,43710.341166f,
43729.621241f,43748.903442f,43768.187767f,43787.474217f,43806.762791f,43826.053489f,43845.346309f,43864.641252f,
43883.938317f,43903.237504f,43922.538812f,43941.842240f,43961.147789f,43980.455457f,43999.765245f,44019.077151f,
44038.391176f,44057.707319f,44077.025579f,44096.345956f,44115.668450f,44134.993059f,44154.319784f,44173.648625f,
44192.979579f,44212.312649f,44231.647831f,44250.985127f,44270.324536f,44289.666057f,44309.009690f,44328.355435f,
44347.703290f,44367.053256f,44386.405332f,44405.759517f,44425.115812f,44444.474215f,44463.834726f,44483.197345f,
44502.562072f,44521.928905f,44541.297845f,44560.668890f,44580.042041f,44599.417297f,44618.794657f,44638.174121f,
44657.555689f,44676.939360f,44696.325134f,44715.713010f,44735.102988f,44754.495067f,44773.889248f,44793.285528f,
44812.683908f,44832.084388f,44851.486967f,44870.891645f,44890.298421f,44909.707294f,44929.118265f,44948.531332f,
44967.946496f,44987.363756f,45006.783111f,45026.204561f,45045.628105f,45065.053744f,45084.481476f,45103.911302f,
45123.343220f,45142.777230f,45162.213332f,45181.651526f,45201.091811f,45220.534185f,45239.978650f,45259.425205f,
45278.873849f,45298.324581f,45317.777402f,45337.232310f,45356.689306f,45376.148388f,45395.609557f,45415.072812f,
45434.538152f,45454.005578f,45473.475088f,45492.946683f,45512.420361f,45531.896122f,45551.373967f,45570.853893f,
45590.335902f,45609.819992f,45629.306164f,45648.794415f,45668.284748f,45687.777159f,45707.271651f,45726.768221f,
45746.266869f,45765.767595f,45785.270399f,45804.775280f,45824.282238f,45843.791272f,45863.302382f,45882.815567f,
45902.330826f,45921.848161f,45941.367569f,45960.889051f,45980.412606f,45999.938233f,46019.465933f,46038.995705f,
46058.527548f,46078.061462f,46097.597446f,46117.135500f,46136.675624f,46156.217818f,46175.762080f,46195.308410f,
46214.856808f,46234.407273f,46253.959806f,46273.514405f,46293.071070f,46312.629800f,46332.190596f,46351.753457f,
46371.318382f,46390.885371f,46410.454424f,46430.025539f,46449.598717f,46469.173958f,46488.751260f,46508.330623f,
46527.912047f,46547.495532f,46567.081077f,46586.668681f,46606.258345f,46625.850067f,46645.443847f,46665.039685f,
46684.637581f,46704.237534f,46723.839543f,46743.443608f,46763.049729f,46782.657906f,46802.268137f,46821.880422f,
46841.494762f,46861.111155f,46880.729601f,46900.350100f,46919.972651f,46939.597254f,46959.223908f,46978.852613f,
46998.483369f,47018.116175f,47037.751030f,47057.387935f,47077.026889f,47096.667890f,47116.310940f,47135.956038f,
47155.603182f,47175.252374f,47194.903611f,47214.556895f,47234.212223f,47253.869597f,47273.529015f,47293.190478f,
47312.853984f,47332.519533f,47352.187126f,47371.856760f,47391.528437f,47411.202155f,47430.877915f,47450.555715f,
47470.235555f,47489.917436f,47509.601356f,47529.287315f,47548.975312f,47568.665348f,47588.357421f,47608.051532f,
47627.747680f,47647.445864f,47667.146085f,47686.848341f,47706.552632f,47726.258958f,47745.967319f,47765.677713f,
47785.390142f,47805.104603f,47824.821097f,47844.539623f,47864.260181f,47883.982771f,47903.707392f,47923.434043f,
47943.162725f,47962.893436f,47982.626177f,48002.360947f,48022.097745f,48041.836572f,48061.577426f,48081.320307f,
48101.065216f,48120.812151f,48140.561111f,48160.312098f,48180.065110f,48199.820146f,48219.577207f,48239.336292f,
48259.097401f,48278.860532f,48298.625687f,48318.392864f,48338.162062f,48357.933282f,48377.706523f,48397.481785f,
48417.259067f,48437.038369f,48456.819691f,48476.603031f,48496.388390f,48516.175767f,48535.965162f,48555.756575f,
48575.550004f,48595.345450f,48615.142912f,48634.942390f,48654.743883f,48674.547391f,48694.352913f,48714.160450f,
48733.970000f,48753.781563f,48773.595140f,48793.410728f,48813.228329f,48833.047942f,48852.869565f,48872.693200f,
48892.518845f,48912.346500f,48932.176164f,48952.007838f,48971.841520f,48991.677211f,49011.514910f,49031.354616f,
49051.196330f,49071.040050f,49090.885777f,49110.733509f,49130.583247f,49150.434991f,49170.288738f,49190.144491f,
49210.002247f,49229.862007f,49249.723769f,49269.587535f,49289.453302f,49309.321072f,49329.190843f,49349.062615f,
49368.936388f,49388.812162f,49408.689935f,49428.569707f,49448.451479f,49468.335249f,49488.221018f,49508.108784f,
49527.998548f,49547.890309f,49567.784066f,49587.679820f,49607.577570f,49627.477315f,49647.379055f,49667.282790f,
49687.188519f,49707.096242f,49727.005959f,49746.917669f,49766.831371f,49786.747065f,49806.664752f,49826.584429f,
49846.506098f,49866.429758f,49886.355408f,49906.283048f,49926.212677f,49946.144295f,49966.077902f,49986.013497f,
50005.951080f,50025.890651f,50045.832209f,50065.775753f,50085.721284f,50105.668801f,50125.618303f,50145.569790f,
50165.523262f,50185.478719f,50205.436159f,50225.395583f,50245.356990f,50265.320380f,50285.285752f,50305.253106f,
50325.222442f,50345.193759f,50365.167057f,50385.142335f,50405.119593f,50425.098830f,50445.080047f,50465.063243f,
50485.048417f,50505.035569f,50525.024699f,50545.015806f,50565.008891f,50585.003951f,50605.000988f,50625.000000f,
50645.000987f,50665.003950f,50685.008887f,50705.015798f,50725.024683f,50745.035541f,50765.048373f,50785.063176f,
50805.079953f,50825.098700f,50845.119420f,50865.142110f,50885.166771f,50905.193402f,50925.222003f,50945.252574f,
50965.285113f,50985.319621f,51005.356098f,51025.394543f,51045.434955f,51065.477334f,51085.521680f,51105.567992f,
51125.616271f,51145.666515f,51165.718724f,51185.772898f,51205.829037f,51225.887139f,51245.947206f,51266.009235f,
51286.073228f,51306.139183f,51326.207100f,51346.276979f,51366.348820f,51386.422621f,51406.498383f,51426.576105f,
51446.655787f,51466.737429f,51486.821030f,51506.906589f,51526.994107f,51547.083582f,51567.175015f,51587.268406f,
51607.363753f,51627.461057f,51647.560316f,51667.661532f,51687.764702f,51707.869828f,51727.976908f,51748.085942f,
51768.196930f,51788.309871f,51808.424765f,51828.541612f,51848.660411f,51868.781162f,51888.903864f,51909.028518f,
51929.155122f,51949.283677f,51969.414181f,51989.546636f,52009.681039f,52029.817391f,52049.955692f,52070.095941f,
52090.238137f,52110.382281f,52130.528372f,52150.676409f,52170.826392f,52190.978322f,52211.132197f,52231.288017f,
52251.445781f,52271.605490f,52291.767143f,52311.930739f,52332.096279f,52352.263761f,52372.433186f,52392.604553f,
52412.777862f,52432.953112f,52453.130303f,52473.309434f,52493.490506f,52513.673518f,52533.858469f,52554.045359f,
52574.234188f,52594.424955f,52614.617660f,52634.812303f,52655.008883f,52675.207400f,52695.407853f,52715.610242f,
52735.814568f,52756.020828f,52776.229024f,52796.439154f,52816.651218f,52836.865217f,52857.081149f,52877.299014f,
52897.518811f,52917.740542f,52937.964204f,52958.189798f,52978.417323f,52998.646779f,53018.878166f,53039.111483f,
53059.346730f,53079.583906f,53099.823011f,53120.064045f,53140.307008f,53160.551898f,53180.798716f,53201.047461f,
53221.298134f,53241.550732f,53261.805257f,53282.061708f,53302.320084f,53322.580385f,53342.842611f,53363.106761f,
53383.372835f,53403.640833f,53423.910754f,53444.182598f,53464.456364f,53484.732053f,53505.009663f,53525.289195f,
53545.570647f,53565.854021f,53586.139315f,53606.426528f,53626.715661f,53647.006714f,53667.299685f,53687.594575f,
53707.891383f,53728.190109f,53748.490752f,53768.793312f,53789.097789f,53809.404183f,53829.712492f,53850.022717f,
53870.334857f,53890.648912f,53910.964881f,53931.282765f,53951.602563f,53971.924274f,53992.247898f,54012.573434f,
54032.900883f,54053.230244f,54073.561517f,54093.894701f,54114.229796f,54134.566802f,54154.905717f,54175.246543f,
54195.589278f,54215.933922f,54236.280475f,54256.628936f,54276.979306f,54297.331583f,54317.685767f,54338.041859f,
54358.399857f,54378.759761f,54399.121571f,54419.485287f,54439.850908f,54460.218434f,54480.587864f,54500.959199f,
54521.332437f,54541.707579f,54562.084623f,54582.463571f,54602.844421f,54623.227172f,54643.611826f,54663.998381f,
54684.386836f,54704.777192f,54725.169449f,54745.563605f,54765.959661f,54786.357616f,54806.757470f,54827.159222f,
54847.562872f,54867.968420f,54888.375866f,54908.785208f,54929.196448f,54949.609583f,54970.024615f,54990.441542f,
55010.860364f,55031.281082f,55051.703694f,55072.128200f,55092.554600f,55112.982894f,55133.413081f,55153.845160f,
55174.279132f,55194.714996f,55215.152752f,55235.592400f,55256.033938f,55276.477367f,55296.922687f,55317.369897f,
55337.818996f,55358.269984f,55378.722862f,55399.177628f,55419.634283f,55440.092825f,55460.553255f,55481.015572f,
55501.479776f,55521.945867f,55542.413844f,55562.883706f,55583.355454f,55603.829088f,55624.304606f,55644.782008f,
55665.261295f,55685.742465f,55706.225519f,55726.710456f,55747.197276f,55767.685978f,55788.176562f,55808.669027f,
55829.163374f,55849.659602f,55870.157711f,55890.657700f,55911.159569f,55931.663318f,55952.168945f,55972.676452f,
55993.185837f,56013.697101f,56034.210242f,56054.725261f,56075.242158f,56095.760931f,56116.281580f,56136.804106f,
56157.328507f,56177.854784f,56198.382937f,56218.912964f,56239.444865f,56259.978641f,56280.514290f,56301.051813f,
56321.591209f,56342.132477f,56362.675618f,56383.220632f,56403.767516f,56424.316273f,56444.866900f,56465.419398f,
56485.973766f,56506.530005f,56527.088113f,56547.648090f,56568.209936f,56588.773651f,56609.339235f,56629.906686f,
56650.476005f,56671.047192f,56691.620245f,56712.195165f,56732.771951f,56753.350603f,56773.931121f,56794.513504f,
56815.097752f,56835.683865f,56856.271841f,56876.861682f,56897.453387f,56918.046954f,56938.642385f,56959.239678f,
56979.838833f,57000.439850f,57021.042729f,57041.647469f,57062.254070f,57082.862532f,57103.472853f,57124.085035f,
57144.699076f,57165.314976f,57185.932736f,57206.552353f,57227.173829f,57247.797163f,57268.422355f,57289.049403f,
57309.678309f,57330.309071f,57350.941689f,57371.576163f,57392.212493f,57412.850678f,57433.490717f,57454.132611f,
57474.776360f,57495.421962f,57516.069418f,57536.718727f,57557.369889f,57578.022903f,57598.677770f,57619.334489f,
57639.993059f,57660.653480f,57681.315752f,57701.979875f,57722.645848f,57743.313670f,57763.983343f,57784.654864f,
57805.328235f,57826.003454f,57846.680521f,57867.359436f,57888.040199f,57908.722809f,57929.407266f,57950.093569f,
57970.781719f,57991.471714f,58012.163556f,58032.857242f,58053.552774f,58074.250150f,58094.949370f,58115.650434f,
58136.353342f,58157.058093f,58177.764687f,58198.473124f,58219.183403f,58239.895524f,58260.609486f,58281.325290f,
58302.042935f,58322.762421f,58343.483747f,58364.206913f,58384.931919f,58405.658764f,58426.387448f,58447.117971f,
58467.850332f,58488.584531f,58509.320568f,58530.058442f,58550.798154f,58571.539702f,58592.283087f,58613.028307f,
58633.775364f,58654.524256f,58675.274983f,58696.027545f,58716.781941f,58737.538172f,58758.296236f,58779.056134f,
58799.817865f,58820.581429f,58841.346826f,58862.114054f,58882.883115f,58903.654007f,58924.426730f,58945.201285f,
58965.977670f,58986.755885f,59007.535930f,59028.317805f,59049.101509f,59069.887042f,59090.674404f,59111.463594f,
59132.254612f,59153.047457f,59173.842131f,59194.638631f,59215.436958f,59236.237111f,59257.039091f,59277.842896f,
59298.648527f,59319.455983f,59340.265263f,59361.076368f,59381.889298f,59402.704051f,59423.520628f,59444.339028f,
59465.159251f,59485.981296f,59506.805164f,59527.630853f,59548.458365f,59569.287697f,59590.118851f,59610.951825f,
59631.786619f,59652.623234f,59673.461668f,59694.301922f,59715.143995f,59735.987886f,59756.833596f,59777.681124f,
59798.530470f,59819.381634f,59840.234614f,59861.089412f,59881.946025f,59902.804456f,59923.664702f,59944.526763f,
59965.390640f,59986.256332f,60007.123839f,60027.993160f,60048.864295f,60069.737243f,60090.612005f,60111.488580f,
60132.366968f,60153.247168f,60174.129181f,60195.013005f,60215.898641f,60236.786088f,60257.675345f,60278.566414f,
60299.459292f,60320.353981f,60341.250479f,60362.148786f,60383.048902f,60403.950827f,60424.854561f,60445.760102f,
60466.667451f,60487.576608f,60508.487572f,60529.400342f,60550.314919f,60571.231302f,60592.149491f,60613.069486f,
60633.991286f,60654.914890f,60675.840300f,60696.767513f,60717.696531f,60738.627352f,60759.559977f,60780.494405f,
60801.430635f,60822.368668f,60843.308503f,60864.250140f,60885.193578f,60906.138818f,60927.085858f,60948.034699f,
60968.985341f,60989.937782f,61010.892023f,61031.848063f,61052.805903f,61073.765541f,61094.726977f,61115.690212f,
61136.655244f,61157.622074f,61178.590701f,61199.561125f,61220.533345f,61241.507362f,61262.483175f,61283.460783f,
61304.440187f,61325.421385f,61346.404379f,61367.389167f,61388.375748f,61409.364124f,61430.354293f,61451.346256f,
61472.340011f,61493.335559f,61514.332899f,61535.332031f,61556.332955f,61577.335670f,61598.340176f,61619.346473f,
61640.354561f,61661.364438f,61682.376105f,61703.389562f,61724.404808f,61745.421843f,61766.440667f,61787.461279f,
61808.483679f,61829.507866f,61850.533841f,61871.561603f,61892.591152f,61913.622487f,61934.655609f,61955.690516f,
61976.727209f,61997.765687f,62018.805950f,62039.847998f,62060.891830f,62081.937447f,62102.984847f,62124.034030f,
62145.084997f,62166.137746f,62187.192278f,62208.248592f,62229.306688f,62250.366566f,62271.428225f,62292.491666f,
62313.556886f,62334.623888f,62355.692669f,62376.763231f,62397.835571f,62418.909692f,62439.985591f,62461.063268f,
62482.142724f,62503.223958f,62524.306970f,62545.391759f,62566.478325f,62587.566669f,62608.656788f,62629.748684f,
62650.842356f,62671.937804f,62693.035026f,62714.134024f,62735.234797f,62756.337344f,62777.441665f,62798.547760f,
62819.655629f,62840.765271f,62861.876685f,62882.989873f,62904.104832f,62925.221564f,62946.340068f,62967.460343f,
62988.582389f,63009.706206f,63030.831794f,63051.959152f,63073.088280f,63094.219178f,63115.351845f,63136.486281f,
63157.622486f,63178.760459f,63199.900200f,63221.041710f,63242.184987f,63263.330032f,63284.476843f,63305.625421f,
63326.775766f,63347.927876f,63369.081753f,63390.237395f,63411.394802f,63432.553975f,63453.714912f,63474.877613f,
63496.042079f,63517.208308f,63538.376300f,63559.546056f,63580.717575f,63601.890856f,63623.065900f,63644.242706f,
63665.421273f,63686.601602f,63707.783692f,63728.967543f,63750.153154f,63771.340526f,63792.529658f,63813.720549f,
63834.913200f,63856.107609f,63877.303778f,63898.501705f,63919.701390f,63940.902834f,63962.106034f,63983.310993f,
64004.517708f,64025.726180f,64046.936408f,64068.148393f,64089.362134f,64110.577630f,64131.794881f,64153.013888f,
64174.234649f,64195.457164f,64216.681434f,64237.907458f,64259.135235f,64280.364765f,64301.596049f,64322.829085f,
64344.063873f,64365.300414f,64386.538707f,64407.778751f,64429.020546f,64450.264092f,64471.509389f,64492.756436f,
64514.005234f,64535.255781f,64556.508078f,64577.762124f,64599.017919f,64620.275462f,64641.534754f,64662.795794f,
64684.058582f,64705.323117f,64726.589400f,64747.857429f,64769.127205f,64790.398728f,64811.671996f,64832.947010f,
64854.223770f,64875.502275f,64896.782525f,64918.064520f,64939.348259f,64960.633742f,64981.920969f,65003.209939f,
65024.500652f,65045.793109f,65067.087308f,65088.383249f,65109.680933f,65130.980358f,65152.281525f,65173.584433f,
65194.889082f,65216.195472f,65237.503601f,65258.813471f,65280.125081f,65301.438431f,65322.753519f,65344.070347f,
65365.388913f,65386.709217f,65408.031260f,65429.355040f,65450.680558f,65472.007814f,65493.336806f,65514.667535f,
65536.000000f,65557.334201f,65578.670138f,65600.007811f,65621.347219f,65642.688362f,65664.031240f,65685.375852f,
65706.722198f,65728.070278f,65749.420092f,65770.771639f,65792.124919f,65813.479931f,65834.836676f,65856.195154f,
65877.555363f,65898.917304f,65920.280976f,65941.646379f,65963.013513f,65984.382377f,66005.752972f,66027.125296f,
66048.499350f,66069.875134f,66091.252646f,66112.631888f,66134.012858f,66155.395556f,66176.779982f,66198.166136f,
66219.554017f,66240.943626f,66262.334961f,66283.728022f,66305.122811f,66326.519325f,66347.917564f,66369.317530f,
66390.719220f,66412.122636f,66433.527775f,66454.934640f,66476.343228f,66497.753540f,66519.165576f,66540.579335f,
66561.994817f,66583.412021f,66604.830948f,66626.251597f,66647.673968f,66669.098061f,66690.523874f,66711.951409f,
66733.380665f,66754.811641f,66776.244337f,66797.678753f,66819.114889f,66840.552744f,66861.992318f,66883.433611f,
66904.876623f,66926.321353f,66947.767800f,66969.215966f,66990.665849f,67012.117449f,67033.570766f,67055.025799f,
67076.482549f,67097.941015f,67119.401197f,67140.863094f,67162.326707f,67183.792034f,67205.259076f,67226.727833f,
67248.198304f,67269.670488f,67291.144386f,67312.619998f,67334.097322f,67355.576360f,67377.057109f,67398.539571f,
67420.023745f,67441.509631f,67462.997228f,67484.486536f,67505.977556f,67527.470285f,67548.964725f,67570.460875f,
67591.958735f,67613.458304f,67634.959583f,67656.462570f,67677.967267f,67699.473671f,67720.981784f,67742.491605f,
67764.003133f,67785.516368f,67807.031311f,67828.547960f,67850.066316f,67871.586379f,67893.108147f,67914.631621f,
67936.156800f,67957.683684f,67979.212274f,68000.742568f,68022.274566f,68043.808269f,68065.343675f,68086.880785f,
68108.419598f,68129.960114f,68151.502333f,68173.046254f,68194.591878f,68216.139203f,68237.688230f,68259.238959f,
68280.791388f,68302.345519f,68323.901350f,68345.458881f,68367.018113f,68388.579044f,68410.141675f,68431.706005f,
68453.272034f,68474.839761f,68496.409188f,68517.980312f,68539.553134f,68561.127654f,68582.703871f,68604.281786f,
68625.861397f,68647.442705f,68669.025709f,68690.610409f,68712.196805f,68733.784896f,68755.374683f,68776.966165f,
68798.559341f,68820.154212f,68841.750777f,68863.349036f,68884.948988f,68906.550634f,68928.153973f,68949.759005f,
68971.365730f,68992.974147f,69014.584256f,69036.196056f,69057.809549f,69079.424732f,69101.041606f,69122.660172f,
69144.280427f,69165.902373f,69187.526009f,69209.151335f,69230.778349f,69252.407054f,69274.037446f,69295.669528f,
69317.303298f,69338.938756f,69360.575902f,69382.214735f,69403.855256f,69425.497464f,69447.141358f,69468.786939f,
69490.434207f,69512.083160f,69533.733799f,69555.386123f,69577.040133f,69598.695828f,69620.353207f,69642.012271f,
69663.673019f,69685.335450f,69706.999566f,69728.665365f,69750.332846f,69772.002011f,69793.672859f,69815.345388f,
69837.019600f,69858.695493f,69880.373068f,69902.052325f,69923.733262f,69945.415880f,69967.100179f,69988.786158f,
70010.473816f,70032.163155f,70053.854173f,70075.546870f,70097.241246f,70118.937301f,70140.635034f,70162.334445f,
70184.035535f,70205.738302f,70227.442746f,70249.148867f,70270.856666f,70292.566140f,70314.277292f,70335.990119f,
70357.704622f,70379.420801f,70401.138655f,70422.858184f,70444.579387f,70466.302266f,70488.026818f,70509.753045f,
70531.480945f,70553.210519f,70574.941767f,70596.674687f,70618.409280f,70640.145545f,70661.883482f,70683.623092f,
70705.364373f,70727.107326f,70748.851950f,70770.598244f,70792.346210f,70814.095846f,70835.847152f,70857.600128f,
70879.354773f,70901.111088f,70922.869072f,70944.628725f,70966.390047f,70988.153037f,71009.917695f,71031.684020f,
71053.452014f,71075.221675f,71096.993003f,71118.765998f,71140.540659f,71162.316986f,71184.094980f,71205.874640f,
71227.655965f,71249.438955f,71271.223611f,71293.009931f,71314.797916f,71336.587565f,71358.378878f,71380.171855f,
71401.966495f,71423.762799f,71445.560765f,71467.360395f,71489.161687f,71510.964641f,71532.769257f,71554.575535f,
71576.383475f,71598.193075f,71620.004337f,71641.817259f,71663.631842f,71685.448085f,71707.265988f,71729.085551f,
71750.906774f,71772.729655f,71794.554196f,71816.380395f,71838.208252f,71860.037768f,71881.868942f,71903.701774f,
71925.536263f,71947.372409f,71969.210212f,71991.049672f,72012.890788f,72034.733561f,72056.577989f,72078.424073f,
72100.271813f,72122.121207f,72143.972257f,72165.824962f,72187.679320f,72209.535333f,72231.393000f,72253.252321f,
72275.113295f,72296.975923f,72318.840203f,72340.706136f,72362.573721f,72384.442959f,72406.313848f,72428.186389f,
72450.060582f,72471.936426f,72493.813921f,72515.693066f,72537.573862f,72559.456308f,72581.340404f,72603.226150f,
72625.113545f,72647.002590f,72668.893283f,72690.785625f,72712.679616f,72734.575255f,72756.472541f,72778.371476f,
72800.272058f,72822.174287f,72844.078163f,72865.983686f,72887.890855f,72909.799670f,72931.710132f,72953.622239f,
72975.535992f,72997.451390f,73019.368433f,73041.287120f,73063.207453f,73085.129429f,73107.053050f,73128.978314f,
73150.905221f,73172.833772f,73194.763966f,73216.695803f,73238.629282f,73260.564404f,73282.501168f,73304.439573f,
73326.379620f,73348.321308f,73370.264638f,73392.209608f,73414.156218f,73436.104469f,73458.054360f,73480.005891f,
73501.959062f,73523.913871f,73545.870320f,73567.828408f,73589.788134f,73611.749499f,73633.712502f,73655.677143f,
73677.643421f,73699.611336f,73721.580889f,73743.552079f,73765.524905f,73787.499368f,73809.475467f,73831.453202f,
73853.432572f,73875.413578f,73897.396219f,73919.380496f,73941.366406f,73963.353952f,73985.343131f,74007.333944f,
74029.326392f,74051.320472f,74073.316186f,74095.313533f,74117.312513f,74139.313125f,74161.315369f,74183.319246f,
74205.324754f,74227.331894f,74249.340665f,74271.351067f,74293.363100f,74315.376763f,74337.392057f,74359.408981f,
74381.427535f,74403.447719f,74425.469532f,74447.492974f,74469.518045f,74491.544744f,74513.573072f,74535.603028f,
74557.634612f,74579.667824f,74601.702663f,74623.739130f,74645.777223f,74667.816943f,74689.858290f,74711.901262f,
74733.945861f,74755.992086f,74778.039936f,74800.089411f,74822.140512f,74844.193237f,74866.247587f,74888.303561f,
74910.361159f,74932.420382f,74954.481227f,74976.543696f,74998.607789f,75020.673504f,75042.740842f,75064.809802f,
75086.880384f,75108.952589f,75131.026415f,75153.101862f,75175.178931f,75197.257621f,75219.337931f,75241.419862f,
75263.503413f,75285.588585f,75307.675376f,75329.763786f,75351.853816f,75373.945465f,75396.038733f,75418.133620f,
75440.230125f,75462.328248f,75484.427989f,75506.529348f,75528.632324f,75550.736917f,75572.843127f,75594.950954f,
75617.060397f,75639.171457f,75661.284133f,75683.398424f,75705.514331f,75727.631854f,75749.750991f,75771.871743f,
75793.994110f,75816.118091f,75838.243686f,75860.370895f,75882.499718f,75904.630154f,75926.762204f,75948.895866f,
75971.031141f,75993.168029f,76015.306528f,76037.446640f,76059.588364f,76081.731699f,76103.876645f,76126.023203f,
76148.171371f,76170.321150f,76192.472539f,76214.625539f,76236.780148f,76258.936367f,76281.094195f,76303.253633f,
76325.414679f,76347.577335f,76369.741598f,76391.907471f,76414.074951f,76436.244038f,76458.414734f,76480.587037f,
76502.760946f,76524.936463f,76547.113587f,76569.292316f,76591.472652f,76613.654594f,76635.838142f,76658.023295f,
76680.210053f,76702.398416f,76724.588384f,76746.779957f,76768.973133f,76791.167914f,76813.364299f,76835.562288f,
76857.761879f,76879.963074f,76902.165872f,76924.370273f,76946.576276f,76968.783881f,76990.993088f,77013.203897f,
77035.416307f,77057.630319f,77079.845932f,77102.063146f,77124.281960f,77146.502375f,77168.724389f,77190.948004f,
77213.173218f,77235.400032f,77257.628445f,77279.858457f,77302.090068f,77324.323278f,77346.558085f,77368.794491f,
77391.032495f,77413.272096f,77435.513295f,77457.756090f,77480.000483f,77502.246472f,77524.494058f,77546.743240f,
77568.994018f,77591.246392f,77613.500362f,77635.755926f,77658.013086f,77680.271841f,77702.532190f,77724.794134f,
77747.057672f,77769.322804f,77791.589530f,77813.857849f,77836.127761f,77858.399266f,77880.672365f,77902.947056f,
77925.223339f,77947.501214f,77969.780681f,77992.061740f,78014.344390f,78036.628632f,78058.914465f,78081.201888f,
78103.490902f,78125.781506f,78148.073700f,78170.367484f,78192.662858f,78214.959821f,78237.258373f,78259.558515f,
78281.860245f,78304.163563f,78326.468470f,78348.774965f,78371.083047f,78393.392718f,78415.703975f,78438.016820f,
78460.331252f,78482.647270f,78504.964875f,78527.284066f,78549.604843f,78571.927206f,78594.251154f,78616.576688f,
78638.903807f,78661.232511f,78683.562799f,78705.894672f,78728.228129f,78750.563170f,78772.899795f,78795.238003f,
78817.577795f,78839.919170f,78862.262127f,78884.606668f,78906.952790f,78929.300495f,78951.649782f,78974.000651f,
78996.353101f,79018.707132f,79041.062745f,79063.419938f,79085.778712f,79108.139067f,79130.501001f,79152.864516f,
79175.229610f,79197.596284f,79219.964537f,79242.334369f,79264.705780f,79287.078770f,79309.453338f,79331.829484f,
79354.207208f,79376.586510f,79398.967389f,79421.349846f,79443.733880f,79466.119490f,79488.506677f,79510.895441f,
79533.285781f,79555.677696f,79578.071188f,79600.466255f,79622.862897f,79645.261114f,79667.660906f,79690.062273f,
79712.465214f,79734.869730f,79757.275819f,79779.683482f,79802.092718f,79824.503528f,79846.915911f,79869.329867f,
79891.745395f,79914.162496f,79936.581169f,79959.001414f,79981.423231f,80003.846619f,80026.271579f,80048.698109f,
80071.126211f,80093.555883f,80115.987126f,80138.419939f,80160.854321f,80183.290274f,80205.727796f,80228.166888f,
80250.607548f,80273.049778f,80295.493576f,80317.938942f,80340.385877f,80362.834380f,80385.284451f,80407.736089f,
80430.189295f,80452.644067f,80475.100407f,80497.558313f,80520.017786f,80542.478825f,80564.941430f,80587.405601f,
80609.871338f,80632.338640f,80654.807507f,80677.277939f,80699.749936f,80722.223497f,80744.698623f,80767.175313f,
80789.653567f,80812.133384f,80834.614765f,80857.097708f,80879.582215f,80902.068285f,80924.555917f,80947.045112f,
80969.535869f,80992.028187f,81014.522068f,81037.017510f,81059.514513f,81082.013077f,81104.513202f,81127.014887f,
81149.518133f,81172.022940f,81194.529306f,81217.037232f,81239.546717f,81262.057762f,81284.570365f,81307.084528f,
81329.600249f,81352.117529f,81374.636367f,81397.156763f,81419.678717f,81442.202229f,81464.727298f,81487.253924f,
81509.782107f,81532.311846f,81554.843142f,81577.375995f,81599.910403f,81622.446368f,81644.983888f,81667.522963f,
81690.063594f,81712.605780f,81735.149520f,81757.694816f,81780.241665f,81802.790069f,81825.340026f,81847.891538f,
81870.444602f,81892.999220f,81915.555392f,81938.113116f,81960.672392f,81983.233221f,82005.795603f,82028.359536f,
82050.925021f,82073.492058f,82096.060646f,82118.630786f,82141.202476f,82163.775717f,82186.350508f,82208.926850f,
82231.504742f,82254.084184f,82276.665175f,82299.247716f,82321.831806f,82344.417445f,82367.004633f,82389.593370f,
82412.183655f,82434.775488f,82457.368869f,82479.963798f,82502.560275f,82525.158298f,82547.757869f,82570.358987f,
82592.961652f,82615.565863f,82638.171620f,82660.778923f,82683.387772f,82705.998167f,82728.610107f,82751.223593f,
82773.838623f,82796.455199f,82819.073319f,82841.692983f,82864.314191f,82886.936943f,82909.561240f,82932.187079f,
82954.814462f,82977.443388f,83000.073857f,83022.705869f,83045.339423f,83067.974519f,83090.611158f,83113.249338f,
83135.889060f,83158.530323f,83181.173128f,83203.817473f,83226.463360f,83249.110787f,83271.759754f,83294.410261f,
83317.062309f,83339.715896f,83362.371023f,83385.027689f,83407.685894f,83430.345638f,83453.006921f,83475.669742f,
83498.334102f,83521.000000f,83543.667435f,83566.336409f,83589.006919f,83611.678967f,83634.352552f,83657.027674f,
83679.704332f,83702.382527f,83725.062258f,83747.743525f,83770.426328f,83793.110666f,83815.796540f,83838.483949f,
83861.172893f,83883.863372f,83906.555385f,83929.248932f,83951.944014f,83974.640629f,83997.338779f,84020.038461f,
84042.739677f,84065.442427f,84088.146709f,84110.852523f,84133.559870f,84156.268750f,84178.979161f,84201.691105f,
84224.404580f,84247.119586f,84269.836124f,84292.554192f,84315.273792f,84337.994922f,84360.717582f,84383.441773f,
84406.167494f,84428.894744f,84451.623524f,84474.353833f,84497.085672f,84519.819040f,84542.553936f,84565.290361f,
84588.028314f,84610.767795f,84633.508804f,84656.251341f,84678.995406f,84701.740998f,84724.488117f,84747.236763f,
84769.986935f,84792.738634f,84815.491860f,84838.246611f,84861.002888f,84883.760691f,84906.520020f,84929.280874f,
84952.043252f,84974.807156f,84997.572584f,85020.339537f,85043.108014f,85065.878015f,85088.649540f,85111.422589f,
85134.197161f,85156.973256f,85179.750874f,85202.530015f,85225.310679f,85248.092865f,85270.876573f,85293.661804f,
85316.448556f,85339.236830f,85362.026625f,85384.817941f,85407.610778f,85430.405137f,85453.201015f,85475.998414f,
85498.797334f,85521.597773f,85544.399732f,85567.203210f,85590.008208f,85612.814726f,85635.622762f,85658.432317f,
85681.243390f,85704.055982f,85726.870092f,85749.685720f,85772.502865f,85795.321528f,85818.141709f,85840.963407f,
85863.786621f,85886.611353f,85909.437601f,85932.265365f,85955.094645f,85977.925442f,86000.757754f,86023.591581f,
86046.426924f,86069.263782f,86092.102155f,86114.942043f,86137.783446f,86160.626362f,86183.470793f,86206.316738f,
86229.164196f,86252.013168f,86274.863653f,86297.715652f,86320.569163f,86343.424187f,86366.280724f,86389.138772f,
86411.998333f,86434.859406f,86457.721991f,86480.586087f,86503.451695f,86526.318813f,86549.187443f,86572.057583f,
86594.929234f,86617.802395f,86640.677067f,86663.553248f,86686.430939f,86709.310139f,86732.190849f,86755.073068f,
86777.956796f,86800.842033f,86823.728778f,86846.617031f,86869.506793f,86892.398062f,86915.290840f,86938.185124f,
86961.080917f,86983.978216f,87006.877022f,87029.777335f,87052.679155f,87075.582481f,87098.487313f,87121.393651f,
87144.301495f,87167.210844f,87190.121699f,87213.034059f,87235.947924f,87258.863293f,87281.780167f,87304.698546f,
87327.618429f,87350.539815f,87373.462706f,87396.387100f,87419.312997f,87442.240398f,87465.169302f,87488.099708f,
87511.031617f,87533.965029f,87556.899942f,87579.836358f,87602.774275f,87625.713694f,87648.654615f,87671.597037f,
87694.540959f,87717.486383f,87740.433307f,87763.381732f,87786.331657f,87809.283082f,87832.236007f,87855.190431f,
87878.146355f,87901.103778f,87924.062700f,87947.023121f,87969.985041f,87992.948459f,88015.913376f,88038.879790f,
88061.847703f,88084.817113f,88107.788021f,88130.760426f,88153.734328f,88176.709727f,88199.686623f,88222.665015f,
88245.644903f,88268.626288f,88291.609169f,88314.593545f,88337.579417f,88360.566785f,88383.555647f,88406.546004f,
88429.537857f,88452.531204f,88475.526045f,88498.522380f,88521.520209f,88544.519533f,88567.520349f,88590.522660f,
88613.526463f,88636.531759f,88659.538549f,88682.546831f,88705.556605f,88728.567872f,88751.580630f,88774.594881f,
88797.610623f,88820.627857f,88843.646582f,88866.666798f,88889.688505f,88912.711702f,88935.736391f,88958.762569f,
88981.790238f,89004.819396f,89027.850045f,89050.882182f,89073.915810f,89096.950926f,89119.987531f,89143.025625f,
89166.065208f,89189.106279f,89212.148839f,89235.192886f,89258.238421f,89281.285444f,89304.333954f,89327.383951f,
89350.435436f,89373.488407f,89396.542865f,89419.598809f,89442.656240f,89465.715157f,89488.775560f,89511.837448f,
89534.900822f,89557.965681f,89581.032026f,89604.099855f,89627.169169f,89650.239968f,89673.312251f,89696.386018f,
89719.461269f,89742.538004f,89765.616223f,89788.695925f,89811.777110f,89834.859779f,89857.943930f,89881.029563f,
89904.116680f,89927.205278f,89950.295359f,89973.386921f,89996.479965f,90019.574491f,90042.670498f,90065.767986f,
90088.866955f,90111.967405f,90135.069335f,90158.172746f,90181.277637f,90204.384008f,90227.491859f,90250.601189f,
90273.711999f,90296.824288f,90319.938056f,90343.053303f,90366.170028f,90389.288232f,90412.407915f,90435.529075f,
90458.651713f,90481.775830f,90504.901423f,90528.028494f,90551.157042f,90574.287067f,90597.418569f,90620.551547f,
90643.686002f,90666.821933f,90689.959340f,90713.098223f,90736.238582f,90759.380416f,90782.523725f,90805.668509f,
90828.814769f,90851.962503f,90875.111711f,90898.262394f,90921.414551f,90944.568182f,90967.723286f,90990.879865f,
91014.037916f,91037.197441f,91060.358439f,91083.520910f,91106.684853f,91129.850269f,91153.017157f,91176.185517f,
91199.355349f,91222.526653f,91245.699428f,91268.873675f,91292.049392f,91315.226581f,91338.405241f,91361.585371f,
91384.766971f,91407.950042f,91431.134582f,91454.320593f,91477.508073f,91500.697023f,91523.887442f,91547.079330f,
91570.272687f,91593.467513f,91616.663807f,91639.861569f,91663.060800f,91686.261499f,91709.463665f,91732.667300f,
91755.872401f,91779.078970f,91802.287006f,91825.496508f,91848.707478f,91871.919914f,91895.133816f,91918.349184f,
91941.566019f,91964.784319f,91988.004084f,92011.225315f,92034.448011f,92057.672173f,92080.897799f,92104.124889f,
92127.353444f,92150.583464f,92173.814947f,92197.047895f,92220.282306f,92243.518180f,92266.755518f,92289.994320f,
92313.234584f,92336.476311f,92359.719500f,92382.964153f,92406.210267f,92429.457843f,92452.706881f,92475.957381f,
92499.209343f,92522.462766f,92545.717649f,92568.973994f,92592.231800f,92615.491066f,92638.751793f,92662.013980f,
92685.277627f,92708.542734f,92731.809300f,92755.077326f,92778.346811f,92801.617756f,92824.890159f,92848.164021f,
92871.439342f,92894.716121f,92917.994359f,92941.274054f,92964.555207f,92987.837818f,93011.121886f,93034.407412f,
93057.694395f,93080.982835f,93104.272731f,93127.564084f,93150.856894f,93174.151159f,93197.446881f,93220.744059f,
93244.042692f,93267.342781f,93290.644325f,93313.947324f,93337.251778f,93360.557687f,93383.865050f,93407.173868f,
93430.484140f,93453.795866f,93477.109046f,93500.423679f,93523.739766f,93547.057307f,93570.376300f,93593.696746f,
93617.018646f,93640.341997f,93663.666801f,93686.993058f,93710.320766f,93733.649926f,93756.980538f,93780.312602f,
93803.646117f,93826.981082f,93850.317499f,93873.655367f,93896.994685f,93920.335454f,93943.677672f,93967.021341f,
93990.366460f,94013.713028f,94037.061046f,94060.410514f,94083.761430f,94107.113796f,94130.467610f,94153.822873f,
94177.179584f,94200.537743f,94223.897351f,94247.258406f,94270.620910f,94293.984860f,94317.350258f,94340.717104f,
94364.085396f,94387.455135f,94410.826321f,94434.198953f,94457.573031f,94480.948556f,94504.325526f,94527.703943f,
94551.083805f,94574.465112f,94597.847864f,94621.232062f,94644.617704f,94668.004791f,94691.393322f,94714.783298f,
94738.174718f,94761.567582f,94784.961889f,94808.357641f,94831.754835f,94855.153473f,94878.553554f,94901.955078f,
94925.358045f,94948.762454f,94972.168305f,94995.575599f,95018.984334f,95042.394512f,95065.806131f,95089.219192f,
95112.633694f,95136.049637f,95159.467021f,95182.885845f,95206.306110f,95229.727816f,95253.150962f,95276.575548f,
95300.001574f,95323.429039f,95346.857944f,95370.288289f,95393.720072f,95417.153295f,95440.587956f,95464.024056f,
95487.461595f,95510.900572f,95534.340986f,95557.782839f,95581.226130f,95604.670858f,95628.117023f,95651.564626f,
95675.013666f,95698.464143f,95721.916056f,95745.369406f,95768.824192f,95792.280414f,95815.738073f,95839.197167f,
95862.657697f,95886.119662f,95909.583063f,95933.047898f,95956.514169f,95979.981874f,96003.451014f,96026.921589f,
96050.393598f,96073.867040f,96097.341917f,96120.818227f,96144.295971f,96167.775148f,96191.255759f,96214.737802f,
96238.221278f,96261.706187f,96285.192529f,96308.680302f,96332.169508f,96355.660146f,96379.152215f,96402.645717f,
96426.140649f,96449.637013f,96473.134808f,96496.634034f,96520.134691f,96543.636778f,96567.140296f,96590.645243f,
96614.151621f,96637.659429f,96661.168667f,96684.679334f,96708.191430f,96731.704955f,96755.219910f,96778.736293f,
96802.254105f,96825.773346f,96849.294015f,96872.816111f,96896.339636f,96919.864589f,96943.390969f,96966.918777f,
96990.448012f,97013.978674f,97037.510763f,97061.044279f,97084.579221f,97108.115590f,97131.653385f,97155.192606f,
97178.733253f,97202.275325f,97225.818824f,97249.363747f,97272.910096f,97296.457870f,97320.007068f,97343.557692f,
97367.109739f,97390.663211f,97414.218108f,97437.774428f,97461.332172f,97484.891340f,97508.451931f,97532.013945f,
97555.577383f,97579.142244f,97602.708527f,97626.276233f,97649.845361f,97673.415912f,97696.987885f,97720.561280f,
97744.136096f,97767.712334f,97791.289993f,97814.869074f,97838.449576f,97862.031499f,97885.614842f,97909.199606f,
97932.785790f,97956.373395f,97979.962419f,98003.552864f,98027.144728f,98050.738012f,98074.332715f,98097.928837f,
98121.526378f,98145.125338f,98168.725717f,98192.327514f,98215.930730f,98239.535364f,98263.141415f,98286.748885f,
98310.357772f,98333.968077f,98357.579799f,98381.192938f,98404.807494f,98428.423467f,98452.040857f,98475.659663f,
98499.279885f,98522.901524f,98546.524578f,98570.149048f,98593.774934f,98617.402235f,98641.030952f,98664.661084f,
98688.292630f,98711.925591f,98735.559967f,98759.195758f,98782.832962f,98806.471581f,98830.111614f,98853.753060f,
98877.395920f,98901.040193f,98924.685880f,98948.332980f,98971.981492f,98995.631418f,99019.282756f,99042.935506f,
99066.589668f,99090.245243f,99113.902229f,99137.560628f,99161.220437f,99184.881659f,99208.544291f,99232.208334f,
99255.873789f,99279.540654f,99303.208929f,99326.878615f,99350.549711f,99374.222218f,99397.896134f,99421.571460f,
99445.248195f,99468.926340f,99492.605893f,99516.286856f,99539.969228f,99563.653009f,99587.338198f,99611.024795f,
99634.712801f,99658.402214f,99682.093036f,99705.785265f,99729.478902f,99753.173946f,99776.870397f,99800.568256f,
99824.267521f,99847.968193f,99871.670271f,99895.373756f,99919.078647f,99942.784944f,99966.492647f,99990.201755f,
100013.912269f,100037.624188f,100061.337513f,100085.052243f,100108.768377f,100132.485916f,100156.204860f,100179.925208f,
100203.646960f,100227.370117f,100251.094677f,100274.820641f,100298.548008f,100322.276779f,100346.006953f,100369.738530f,
100393.471510f,100417.205892f,100440.941677f,100464.678865f,100488.417454f,100512.157446f,100535.898839f,100559.641635f,
100583.385831f,100607.131430f,100630.878429f,100654.626829f,100678.376631f,100702.127833f,100725.880435f,100749.634438f,
100773.389841f,100797.146645f,100820.904848f,100844.664451f,100868.425453f,100892.187855f,100915.951656f,100939.716856f,
100963.483455f,100987.251452f,101011.020849f,101034.791643f,101058.563836f,101082.337427f,101106.112416f,101129.888803f,
101153.666587f,101177.445769f,101201.226348f,101225.008324f,101248.791697f,101272.576466f,101296.362633f,101320.150195f,
101343.939154f,101367.729509f,101391.521260f,101415.314407f,101439.108950f,101462.904888f,101486.702221f,101510.500949f,
101534.301072f,101558.102590f,101581.905503f,101605.709810f,101629.515512f,101653.322607f,101677.131097f,101700.940980f,
101724.752258f,101748.564928f,101772.378992f,101796.194449f,101820.011299f,101843.829542f,101867.649178f,101891.470206f,
101915.292626f,101939.116439f,101962.941643f,101986.768240f,102010.596228f,102034.425608f,102058.256379f,102082.088541f,
102105.922095f,102129.757039f,102153.593374f,102177.431099f,102201.270215f,102225.110722f,102248.952618f,102272.795904f,
102296.640580f,102320.486646f,102344.334101f,102368.182945f,102392.033178f,102415.884800f,102439.737811f,102463.592211f,
102487.447999f,102511.305176f,102535.163740f,102559.023693f,102582.885033f,102606.747761f,102630.611877f,102654.477379f,
102678.344269f,102702.212546f,102726.082210f,102749.953261f,102773.825698f,102797.699521f,102821.574731f,102845.451326f,
102869.329308f,102893.208675f,102917.089428f,102940.971566f,102964.855090f,102988.739998f,103012.626291f,103036.513970f,
103060.403032f,103084.293479f,103108.185311f,103132.078527f,103155.973126f,103179.869109f,103203.766476f,103227.665227f,
103251.565360f,103275.466877f,103299.369777f,103323.274060f,103347.179725f,103371.086773f,103394.995203f,103418.905016f,
103442.816210f,103466.728786f,103490.642744f,103514.558084f,103538.474805f,103562.392907f,103586.312390f,103610.233254f,
103634.155499f,103658.079125f,103682.004131f,103705.930517f,103729.858283f,103753.787430f,103777.717956f,103801.649862f,
103825.583147f,103849.517811f,103873.453855f,103897.391278f,103921.330079f,103945.270260f,103969.211818f,103993.154755f,
104017.099071f,104041.044764f,104064.991835f,104088.940284f,104112.890111f,104136.841315f,104160.793896f,104184.747855f,
104208.703190f,104232.659902f,104256.617991f,104280.577456f,104304.538297f,104328.500515f,104352.464109f,104376.429078f,
104400.395423f,104424.363144f,104448.332240f,104472.302711f,104496.274557f,104520.247779f,104544.222375f,104568.198345f,
104592.175690f,104616.154409f,104640.134502f,104664.115969f,104688.098810f,104712.083025f,104736.068613f,104760.055574f,
104784.043909f,104808.033616f,104832.024697f,104856.017150f,104880.010975f,104904.006173f,104928.002743f,104952.000686f,
104976.000000f,105000.000686f,105024.002743f,105048.006172f,105072.010972f,105096.017143f,105120.024685f,105144.033598f,
105168.043882f,105192.055536f,105216.068561f,105240.082955f,105264.098720f,105288.115855f,105312.134359f,105336.154233f,
105360.175476f,105384.198088f,105408.222070f,105432.247420f,105456.274139f,105480.302227f,105504.331683f,105528.362508f,
105552.394701f,105576.428261f,105600.463190f,105624.499486f,105648.537150f,105672.576181f,105696.616580f,105720.658345f,
105744.701477f,105768.745976f,105792.791842f,105816.839074f,105840.887672f,105864.937637f,105888.988967f,105913.041664f,
105937.095726f,105961.151153f,105985.207946f,106009.266104f,106033.325627f,106057.386515f,106081.448767f,106105.512385f,
106129.577366f,106153.643712f,106177.711422f,106201.780496f,106225.850934f,106249.922735f,106273.995900f,106298.070429f,
106322.146320f,106346.223574f,106370.302192f,106394.382172f,106418.463515f,106442.546220f,106466.630287f,106490.715716f,
106514.802508f,106538.890661f,106562.980176f,106587.071052f,106611.163290f,106635.256888f,106659.351848f,106683.448169f,
106707.545850f,106731.644892f,106755.745295f,106779.847058f,106803.950180f,106828.054663f,106852.160506f,106876.267708f,
106900.376270f,106924.486191f,106948.597471f,106972.710110f,106996.824108f,107020.939465f,107045.056180f,107069.174254f,
107093.293686f,107117.414477f,107141.536625f,107165.660131f,107189.784994f,107213.911216f,107238.038794f,107262.167730f,
107286.298023f,107310.429672f,107334.562679f,107358.697041f,107382.832761f,107406.969837f,107431.108268f,107455.248056f,
107479.389200f,107503.531699f,107527.675554f,107551.820764f,107575.967329f,107600.115250f,107624.264525f,107648.415155f,
107672.567140f,107696.720479f,107720.875173f,107745.031220f,107769.188622f,107793.347378f,107817.507487f,107841.668950f,
107865.831766f,107889.995935f,107914.161457f,107938.328333f,107962.496561f,107986.666142f,108010.837075f,108035.009361f,
108059.182999f,108083.357989f,108107.534330f,108131.712024f,108155.891069f,108180.071465f,108204.253213f,108228.436312f,
108252.620762f,108276.806562f,108300.993714f,108325.182216f,108349.372068f,108373.563270f,108397.755823f,108421.949725f,
108446.144977f,108470.341579f,108494.539531f,108518.738831f,108542.939481f,108567.141480f,108591.344827f,108615.549524f,
108639.755569f,108663.962962f,108688.171704f,108712.381793f,108736.593231f,108760.806016f,108785.020150f,108809.235630f,
108833.452458f,108857.670634f,108881.890156f,108906.111025f,108930.333241f,108954.556804f,108978.781713f,109003.007968f,
109027.235570f,109051.464517f,109075.694811f,109099.926450f,109124.159434f,109148.393765f,109172.629440f,109196.866460f,
109221.104826f,109245.344536f,109269.585591f,109293.827991f,109318.071735f,109342.316823f,109366.563255f,109390.811031f,
109415.060151f,109439.310614f,109463.562421f,109487.815571f,109512.070065f,109536.325901f,109560.583081f,109584.841603f,
109609.101468f,109633.362675f,109657.625224f,109681.889116f,109706.154349f,109730.420925f,109754.688842f,109778.958101f,
109803.228701f,109827.500642f,109851.773924f,109876.048548f,109900.324512f,109924.601817f,109948.880462f,109973.160448f,
109997.441774f,110021.724440f,110046.008446f,110070.293791f,110094.580477f,110118.868501f,110143.157866f,110167.448569f,
110191.740611f,110216.033992f,110240.328712f,110264.624771f,110288.922168f,110313.220903f,110337.520976f,110361.822388f,
110386.125137f,110410.429224f,110434.734648f,110459.041410f,110483.349510f,110507.658946f,110531.969719f,110556.281829f,
110580.595276f,110604.910059f,110629.226179f,110653.543635f,110677.862427f,110702.182555f,110726.504019f,110750.826818f,
110775.150953f,110799.476423f,110823.803229f,110848.131369f,110872.460844f,110896.791655f,110921.123799f,110945.457279f,
110969.792092f,110994.128240f,111018.465722f,111042.804538f,111067.144687f,111091.486170f,111115.828987f,111140.173136f,
111164.518619f,111188.865435f,111213.213584f,111237.563066f,111261.913880f,111286.266027f,111310.619505f,111334.974316f,
111359.330459f,111383.687934f,111408.046741f,111432.406879f,111456.768348f,111481.131149f,111505.495281f,111529.860744f,
111554.227538f,111578.595662f,111602.965117f,111627.335902f,111651.708018f,111676.081463f,111700.456239f,111724.832344f,
111749.209779f,111773.588544f,111797.968638f,111822.350061f,111846.732813f,111871.116895f,111895.502305f,111919.889043f,
111944.277111f,111968.666506f,111993.057230f,112017.449282f,112041.842662f,112066.237369f,112090.633404f,112115.030767f,
112139.429457f,112163.829474f,112188.230819f,112212.633490f,112237.037488f,112261.442812f,112285.849464f,112310.257441f,
112334.666745f,112359.077374f,112383.489330f,112407.902611f,112432.317218f,112456.733151f,112481.150409f,112505.568992f,
112529.988900f,112554.410133f,112578.832690f,112603.256573f,112627.681779f,112652.108310f,112676.536166f,112700.965345f,
112725.395848f,112749.827675f,112774.260826f,112798.695300f,112823.131097f,112847.568218f,112872.006661f,112896.446428f,
112920.887517f,112945.329929f,112969.773663f,112994.218720f,113018.665099f,113043.112799f,113067.561822f,113092.012166f,
113116.463833f,113140.916820f,113165.371129f,113189.826759f,113214.283710f,113238.741982f,113263.201575f,113287.662488f,
113312.124722f,113336.588276f,113361.053150f,113385.519344f,113409.986858f,113434.455692f,113458.925846f,113483.397319f,
113507.870111f,113532.344223f,113556.819653f,113581.296403f,113605.774471f,113630.253858f,113654.734563f,113679.216587f,
113703.699928f,113728.184588f,113752.670566f,113777.157862f,113801.646475f,113826.136405f,113850.627653f,113875.120218f,
113899.614101f,113924.109300f,113948.605816f,113973.103648f,113997.602797f,114022.103262f,114046.605044f,114071.108141f,
114095.612555f,114120.118284f,114144.625329f,114169.133690f,114193.643365f,114218.154356f,114242.666662f,114267.180283f,
114291.695219f,114316.211470f,114340.729035f,114365.247914f,114389.768107f,114414.289615f,114438.812437f,114463.336572f,
114487.862021f,114512.388784f,114536.916860f,114561.446249f,114585.976951f,114610.508966f,114635.042294f,114659.576935f,
114684.112889f,114708.650154f,114733.188732f,114757.728622f,114782.269824f,114806.812338f,114831.356164f,114855.901301f,
114880.447749f,114904.995509f,114929.544580f,114954.094962f,114978.646655f,115003.199659f,115027.753973f,115052.309597f,
115076.866532f,115101.424777f,115125.984332f,115150.545197f,115175.107372f,115199.670856f,115224.235650f,115248.801753f,
115273.369165f,115297.937886f,115322.507916f,115347.079255f,115371.651903f,115396.225859f,115420.801123f,115445.377696f,
115469.955576f,115494.534765f,115519.115261f,115543.697065f,115568.280177f,115592.864595f,115617.450322f,115642.037355f,
115666.625695f,115691.215342f,115715.806295f,115740.398556f,115764.992122f,115789.586995f,115814.183174f,115838.780659f,
115863.379449f,115887.979546f,115912.580948f,115937.183655f,115961.787668f,115986.392986f,116010.999609f,116035.607537f,
116060.216769f,116084.827306f,116109.439148f,116134.052294f,116158.666744f,116183.282498f,116207.899556f,116232.517917f,
116257.137583f,116281.758552f,116306.380824f,116331.004399f,116355.629278f,116380.255459f,116404.882944f,116429.511730f,
116454.141820f,116478.773212f,116503.405906f,116528.039902f,116552.675200f,116577.311800f,116601.949702f,116626.588905f,
116651.229410f,116675.871216f,116700.514323f,116725.158731f,116749.804440f,116774.451450f,116799.099760f,116823.749371f,
116848.400282f,116873.052493f,116897.706005f,116922.360816f,116947.016927f,116971.674338f,116996.333048f,117020.993057f,
117045.654366f,117070.316974f,117094.980881f,117119.646087f,117144.312591f,117168.980394f,117193.649495f,117218.319895f,
117242.991592f,117267.664588f,117292.338882f,117317.014473f,117341.691362f,117366.369548f,117391.049032f,117415.729813f,
117440.411890f,117465.095265f,117489.779937f,117514.465905f,117539.153170f,117563.841731f,117588.531588f,117613.222741f,
117637.915190f,117662.608936f,117687.303976f,117712.000313f,117736.697944f,117761.396871f,117786.097094f,117810.798611f,
117835.501423f,117860.205530f,117884.910931f,117909.617627f,117934.325617f,117959.034901f,117983.745480f,118008.457352f,
118033.170518f,118057.884978f,118082.600731f,118107.317778f,118132.036117f,118156.755750f,118181.476676f,118206.198895f,
118230.922406f,118255.647210f,118280.373307f,118305.100696f,118329.829377f,118354.559349f,118379.290614f,118404.023171f,
118428.757019f,118453.492159f,118478.228590f,118502.966312f,118527.705325f,118552.445630f,118577.187225f,118601.930110f,
118626.674287f,118651.419753f,118676.166510f,118700.914557f,118725.663894f,118750.414521f,118775.166438f,118799.919644f,
118824.674140f,118849.429925f,118874.187000f,118898.945363f,118923.705015f,118948.465956f,118973.228186f,118997.991704f,
119022.756511f,119047.522606f,119072.289989f,119097.058660f,119121.828619f,119146.599865f,119171.372399f,119196.146221f,
119220.921330f,119245.697726f,119270.475409f,119295.254379f,119320.034636f,119344.816180f,119369.599010f,119394.383126f,
119419.168529f,119443.955218f,119468.743193f,119493.532453f,119518.323000f,119543.114832f,119567.907949f,119592.702352f,
119617.498040f,119642.295012f,119667.093270f,119691.892813f,119716.693640f,119741.495752f,119766.299148f,119791.103829f,
119815.909793f,119840.717042f,119865.525574f,119890.335390f,119915.146490f,119939.958873f,119964.772540f,119989.587489f,
120014.403722f,120039.221238f,120064.040036f,120088.860117f,120113.681481f,120138.504127f,120163.328055f,120188.153266f,
120212.979758f,120237.807532f,120262.636588f,120287.466926f,120312.298545f,120337.131446f,120361.965627f,120386.801090f,
120411.637833f,120436.475858f,120461.315163f,120486.155749f,120510.997615f,120535.840761f,120560.685187f,120585.530894f,
120610.377880f,120635.226146f,120660.075692f,120684.926517f,120709.778622f,120734.632006f,120759.486669f,120784.342610f,
120809.199831f,120834.058331f,120858.918108f,120883.779165f,120908.641499f,120933.505112f,120958.370003f,120983.236172f,
121008.103619f,121032.972343f,121057.842345f,121082.713624f,121107.586180f,121132.460013f,121157.335124f,121182.211511f,
121207.089175f,121231.968116f,121256.848333f,121281.729827f,121306.612596f,121331.496642f,121356.381964f,121381.268561f,
121406.156434f,121431.045583f,121455.936007f,121480.827706f,121505.720681f,121530.614931f,121555.510455f,121580.407254f,
121605.305328f,121630.204677f,121655.105299f,121680.007196f,121704.910368f,121729.814813f,121754.720532f,121779.627524f,
121804.535791f,121829.445330f,121854.356143f,121879.268230f,121904.181589f,121929.096221f,121954.012126f,121978.929304f,
122003.847754f,122028.767477f,122053.688472f,122078.610739f,122103.534279f,122128.459090f,122153.385173f,122178.312527f,
122203.241153f,122228.171051f,122253.102219f,122278.034659f,122302.968370f,122327.903352f,122352.839604f,122377.777127f,
122402.715921f,122427.655984f,122452.597318f,122477.539922f,122502.483797f,122527.428940f,122552.375354f,122577.323037f,
122602.271990f,122627.222212f,122652.173703f,122677.126463f,122702.080492f,122727.035790f,122751.992357f,122776.950192f,
122801.909295f,122826.869667f,122851.831307f,122876.794215f,122901.758391f,122926.723834f,122951.690546f,122976.658524f,
123001.627770f,123026.598284f,123051.570064f,123076.543112f,123101.517426f,123126.493007f,123151.469855f,123176.447969f,
123201.427350f,123226.407996f,123251.389909f,123276.373088f,123301.357533f,123326.343243f,123351.330219f,123376.318460f,
123401.307967f,123426.298739f,123451.290776f,123476.284078f,123501.278645f,123526.274476f,123551.271572f,123576.269932f,
123601.269557f,123626.270446f,123651.272599f,123676.276016f,123701.280696f,123726.286640f,123751.293848f,123776.302319f,
123801.312054f,123826.323051f,123851.335312f,123876.348836f,123901.363622f,123926.379671f,123951.396982f,123976.415556f,
124001.435392f,124026.456491f,124051.478851f,124076.502473f,124101.527357f,124126.553502f,124151.580909f,124176.609578f,
124201.639507f,124226.670698f,124251.703150f,124276.736862f,124301.771835f,124326.808069f,124351.845564f,124376.884318f,
124401.924333f,124426.965608f,124452.008143f,124477.051938f,124502.096993f,124527.143307f,124552.190880f,124577.239713f,
124602.289805f,124627.341157f,124652.393767f,124677.447636f,124702.502764f,124727.559150f,124752.616795f,124777.675698f,
124802.735859f,124827.797278f,124852.859956f,124877.923891f,124902.989084f,124928.055534f,124953.123242f,124978.192207f,
125003.262429f,125028.333909f,125053.406645f,125078.480638f,125103.555888f,125128.632394f,125153.710157f,125178.789176f,
125203.869451f,125228.950983f,125254.033770f,125279.117813f,125304.203112f,125329.289666f,125354.377476f,125379.466541f,
125404.556861f,125429.648436f,125454.741267f,125479.835352f,125504.930691f,125530.027285f,125555.125134f,125580.224237f,
125605.324594f,125630.426205f,125655.529070f,125680.633189f,125705.738562f,125730.845188f,125755.953067f,125781.062200f,
125806.172586f,125831.284225f,125856.397117f,125881.511261f,125906.626659f,125931.743309f,125956.861211f,125981.980366f,
126007.100773f,126032.222431f,126057.345342f,126082.469505f,126107.594919f,126132.721585f,126157.849502f,126182.978670f,
126208.109090f,126233.240761f,126258.373682f,126283.507855f,126308.643278f,126333.779952f,126358.917876f,126384.057050f,
126409.197475f,126434.339149f,126459.482074f,126484.626248f,126509.771672f,126534.918346f,126560.066269f,126585.215441f,
126610.365863f,126635.517533f,126660.670453f,126685.824621f,126710.980038f,126736.136704f,126761.294618f,126786.453780f,
126811.614191f,126836.775849f,126861.938756f,126887.102910f,126912.268312f,126937.434962f,126962.602859f,126987.772003f,
127012.942395f,127038.114033f,127063.286919f,127088.461051f,127113.636430f,127138.813056f,127163.990928f,127189.170047f,
127214.350412f,127239.532023f,127264.714879f,127289.898982f,127315.084330f,127340.270924f,127365.458764f,127390.647849f,
127415.838179f,127441.029754f,127466.222574f,127491.416639f,127516.611948f,127541.808503f,127567.006301f,127592.205345f,
127617.405632f,127642.607164f,127667.809939f,127693.013958f,127718.219222f,127743.425728f,127768.633479f,127793.842472f,
127819.052709f,127844.264189f,127869.476912f,127894.690878f,127919.906087f,127945.122539f,127970.340233f,127995.559169f,
128020.779347f,128046.000768f,128071.223431f,128096.447336f,128121.672482f,128146.898870f,128172.126500f,128197.355371f,
128222.585484f,128247.816837f,128273.049432f,128298.283268f,128323.518344f,128348.754661f,128373.992219f,128399.231017f,
128424.471056f,128449.712335f,128474.954853f,128500.198612f,128525.443611f,128550.689849f,128575.937327f,128601.186044f,
128626.436001f,128651.687197f,128676.939632f,128702.193306f,128727.448219f,128752.704371f,128777.961761f,128803.220390f,
128828.480257f,128853.741362f,128879.003706f,128904.267287f,128929.532107f,128954.798164f,128980.065459f,129005.333992f,
129030.603761f,129055.874769f,129081.147013f,129106.420494f,129131.695213f,129156.971168f,129182.248359f,129207.526788f,
129232.806452f,129258.087354f,129283.369491f,129308.652864f,129333.937474f,129359.223319f,129384.510400f,129409.798716f,
129435.088268f,129460.379055f,129485.671078f,129510.964336f,129536.258828f,129561.554556f,129586.851518f,129612.149715f,
129637.449146f,129662.749812f,129688.051712f,129713.354846f,129738.659215f,129763.964817f,129789.271653f,129814.579722f,
129839.889025f,129865.199562f,129890.511332f,129915.824335f,129941.138571f,129966.454040f,129991.770742f,130017.088677f,
130042.407844f,130067.728244f,130093.049876f,130118.372740f,130143.696836f,130169.022165f,130194.348725f,130219.676517f,
130245.005540f,130270.335795f,130295.667282f,130321.000000f,130346.333949f,130371.669128f,130397.005539f,130422.343181f,
130447.682053f,130473.022156f,130498.363489f,130523.706053f,130549.049847f,130574.394870f,130599.741124f,130625.088608f,
130650.437321f,130675.787264f,130701.138437f,130726.490838f,130751.844469f,130777.199329f,130802.555419f,130827.912737f,
130853.271283f,130878.631059f,130903.992063f,130929.354295f,130954.717756f,130980.082444f,131005.448361f,131030.815506f,
131056.183878f,131081.553479f,131106.924307f,131132.296362f,131157.669644f,131183.044154f,131208.419891f,131233.796855f,
131259.175046f,131284.554463f,131309.935107f,131335.316978f,131360.700075f,131386.084398f,131411.469948f,131436.856723f,
131462.244725f,131487.633952f,131513.024405f,131538.416083f,131563.808987f,131589.203116f,131614.598470f,131639.995050f,
131665.392854f,131690.791883f,131716.192137f,131741.593616f,131766.996319f,131792.400246f,131817.805398f,131843.211774f,
131868.619374f,131894.028197f,131919.438245f,131944.849516f,131970.262011f,131995.675729f,132021.090671f,132046.506835f,
132071.924223f,132097.342834f,132122.762667f,132148.183724f,132173.606003f,132199.029504f,132224.454228f,132249.880174f,
132275.307342f,132300.735732f,132326.165344f,132351.596178f,132377.028234f,132402.461511f,132427.896009f,132453.331729f,
132478.768670f,132504.206832f,132529.646215f,132555.086819f,132580.528644f,132605.971689f,132631.415955f,132656.861441f,
132682.308147f,132707.756074f,132733.205221f,132758.655587f,132784.107173f,132809.559979f,132835.014005f,132860.469250f,
132885.925714f,132911.383397f,132936.842300f,132962.302421f,132987.763762f,133013.226321f,133038.690099f,133064.155095f,
133089.621310f,133115.088743f,133140.557394f,133166.027263f,133191.498350f,133216.970655f,133242.444177f,133267.918918f,
133293.394875f,133318.872050f,133344.350442f,133369.830052f,133395.310878f,133420.792921f,133446.276181f,133471.760658f,
133497.246351f,133522.733260f,133548.221386f,133573.710728f,133599.201286f,133624.693060f,133650.186050f,133675.680255f,
133701.175677f,133726.672313f,133752.170165f,133777.669233f,133803.169515f,133828.671012f,133854.173725f,133879.677652f,
133905.182794f,133930.689150f,133956.196721f,133981.705506f,134007.215505f,134032.726719f,134058.239146f,134083.752787f,
134109.267643f,134134.783711f,134160.300993f,134185.819489f,134211.339198f,134236.860120f,134262.382255f,134287.905603f,
134313.430164f,134338.955938f,134364.482924f,134390.011123f,134415.540534f,134441.071157f,134466.602992f,134492.136040f,
134517.670299f,134543.205770f,134568.742453f,134594.280348f,134619.819453f,134645.359771f,134670.901299f,134696.444038f,
134721.987989f,134747.533150f,134773.079522f,134798.627105f,134824.175898f,134849.725902f,134875.277116f,134900.829540f,
134926.383174f,134951.938019f,134977.494073f,135003.051336f,135028.609810f,135054.169493f,135079.730385f,135105.292486f,
135130.855797f,135156.420317f,135181.986046f,135207.552983f,135233.121129f,135258.690484f,135284.261047f,135309.832819f,
135335.405798f,135360.979986f,135386.555382f,135412.131986f,135437.709798f,135463.288817f,135488.869044f,135514.450478f,
135540.033119f,135565.616968f,135591.202024f,135616.788287f,135642.375757f,135667.964433f,135693.554316f,135719.145406f,
135744.737702f,135770.331205f,135795.925913f,135821.521828f,135847.118948f,135872.717275f,135898.316807f,135923.917545f,
135949.519488f,135975.122637f,136000.726991f,136026.332550f,136051.939314f,136077.547284f,136103.156458f,136128.766836f,
136154.378420f,136179.991207f,136205.605199f,136231.220396f,136256.836796f,136282.454401f,136308.073210f,136333.693222f,
136359.314438f,136384.936857f,136410.560481f,136436.185307f,136461.811337f,136487.438569f,136513.067005f,136538.696644f,
136564.327485f,136589.959530f,136615.592776f,136641.227225f,136666.862877f,136692.499731f,136718.137787f,136743.777044f,
136769.417504f,136795.059166f,136820.702029f,136846.346094f,136871.991360f,136897.637827f,136923.285496f,136948.934366f,
136974.584437f,137000.235708f,137025.888181f,137051.541854f,137077.196727f,137102.852801f,137128.510076f,137154.168550f,
137179.828225f,137205.489099f,137231.151174f,137256.814448f,137282.478922f,137308.144595f,137333.811468f,137359.479540f,
137385.148812f,137410.819282f,137436.490951f,137462.163820f,137487.837886f,137513.513152f,137539.189616f,137564.867279f,
137590.546139f,137616.226198f,137641.907455f,137667.589910f,137693.273563f,137718.958414f,137744.644462f,137770.331708f,
137796.020151f,137821.709791f,137847.400629f,137873.092664f,137898.785895f,137924.480324f,137950.175949f,137975.872771f,
138001.570789f,138027.270004f,138052.970415f,138078.672022f,138104.374825f,138130.078824f,138155.784019f,138181.490410f,
138207.197996f,138232.906778f,138258.616756f,138284.327928f,138310.040296f,138335.753859f,138361.468616f,138387.184569f,
138412.901716f,138438.620058f,138464.339595f,138490.060326f,138515.782251f,138541.505370f,138567.229683f,138592.955191f,
138618.681892f,138644.409787f,138670.138875f,138695.869157f,138721.600633f,138747.333302f,138773.067163f,138798.802218f,
138824.538466f,138850.275907f,138876.014541f,138901.754367f,138927.495385f,138953.237596f,138978.981000f,139004.725595f,
139030.471383f,139056.218362f,139081.966534f,139107.715897f,139133.466452f,139159.218198f,139184.971136f,139210.725265f,
139236.480585f,139262.237096f,139287.994798f,139313.753692f,139339.513775f,139365.275050f,139391.037515f,139416.801170f,
139442.566016f,139468.332052f,139494.099278f,139519.867694f,139545.637300f,139571.408096f,139597.180081f,139622.953256f,
139648.727620f,139674.503174f,139700.279917f,139726.057848f,139751.836969f,139777.617279f,139803.398778f,139829.181465f,
139854.965341f,139880.750405f,139906.536657f,139932.324098f,139958.112727f,139983.902544f,140009.693549f,140035.485741f,
140061.279122f,140087.073689f,140112.869445f,140138.666387f,140164.464517f,140190.263834f,140216.064338f,140241.866029f,
140267.668907f,140293.472971f,140319.278222f,140345.084660f,140370.892284f,140396.701094f,140422.511090f,140448.322272f,
140474.134641f,140499.948195f,140525.762934f,140551.578860f,140577.395971f,140603.214267f,140629.033748f,140654.854415f,
140680.676267f,140706.499304f,140732.323525f,140758.148931f,140783.975522f,140809.803298f,140835.632258f,140861.462402f,
140887.293730f,140913.126242f,140938.959939f,140964.794819f,140990.630883f,141016.468131f,141042.306562f,141068.146176f,
141093.986974f,141119.828956f,141145.672120f,141171.516467f,141197.361997f,141223.208710f,141249.056606f,141274.905684f,
141300.755944f,141326.607387f,141352.460013f,141378.313820f,141404.168809f,141430.024981f,141455.882334f,141481.740868f,
141507.600585f,141533.461483f,141559.323562f,141585.186822f,141611.051264f,141636.916887f,141662.783690f,141688.651675f,
141714.520840f,141740.391186f,141766.262712f,141792.135419f,141818.009306f,141843.884373f,141869.760621f,141895.638048f,
141921.516655f,141947.396442f,141973.277408f,141999.159555f,142025.042880f,142050.927385f,142076.813069f,142102.699932f,
142128.587975f,142154.477196f,142180.367596f,142206.259174f,142232.151931f,142258.045867f,142283.940981f,142309.837273f,
142335.734744f,142361.633392f,142387.533219f,142413.434223f,142439.336405f,142465.239764f,142491.144301f,142517.050016f,
142542.956907f,142568.864976f,142594.774222f,142620.684645f,142646.596245f,142672.509022f,142698.422975f,142724.338105f,
142750.254411f,142776.171894f,142802.090552f,142828.010387f,142853.931398f,142879.853585f,142905.776948f,142931.701486f,
142957.627200f,142983.554089f,143009.482154f,143035.411394f,143061.341809f,143087.273399f,143113.206164f,143139.140104f,
143165.075219f,143191.011508f,143216.948972f,143242.887610f,143268.827423f,143294.768410f,143320.710571f,143346.653905f,
143372.598414f,143398.544097f,143424.490953f,143450.438983f,143476.388186f,143502.338562f,143528.290112f,143554.242835f,
143580.196731f,143606.151800f,143632.108041f,143658.065456f,143684.024043f,143709.983802f,143735.944734f,143761.906838f,
143787.870115f,143813.834563f,143839.800184f,143865.766976f,143891.734940f,143917.704076f,143943.674383f,143969.645862f,
143995.618512f,144021.592333f,144047.567325f,144073.543489f,144099.520823f,144125.499328f,144151.479004f,144177.459850f,
144203.441867f,144229.425055f,144255.409412f,144281.394940f,144307.381638f,144333.369506f,144359.358543f,144385.348751f,
144411.340128f,144437.332674f,144463.326390f,144489.321276f,144515.317331f,144541.314554f,144567.312947f,144593.312509f,
144619.313239f,144645.315138f,144671.318206f,144697.322442f,144723.327847f,144749.334420f,144775.342161f,144801.351070f,
144827.361148f,144853.372393f,144879.384805f,144905.398386f,144931.413134f,144957.429049f,144983.446132f,145009.464382f,
145035.483799f,145061.504383f,145087.526135f,145113.549052f,145139.573137f,145165.598388f,145191.624806f,145217.652390f,
145243.681141f,145269.711057f,145295.742140f,145321.774389f,145347.807803f,145373.842384f,145399.878130f,145425.915041f,
145451.953118f,145477.992360f,145504.032768f,145530.074341f,145556.117079f,145582.160981f,145608.206049f,145634.252281f,
145660.299678f,145686.348240f,145712.397965f,145738.448856f,145764.500910f,145790.554128f,145816.608511f,145842.664057f,
145868.720767f,145894.778641f,145920.837679f,145946.897880f,145972.959244f,145999.021772f,146025.085462f,146051.150316f,
146077.216333f,146103.283512f,146129.351855f,146155.421360f,146181.492027f,146207.563857f,146233.636850f,146259.711004f,
146285.786321f,146311.862800f,146337.940440f,146364.019243f,146390.099207f,146416.180333f,146442.262620f,146468.346069f,
146494.430679f,146520.516450f,146546.603383f,146572.691476f,146598.780730f,146624.871145f,146650.962721f,146677.055457f,
146703.149354f,146729.244411f,146755.340628f,146781.438006f,146807.536543f,146833.636241f,146859.737098f,146885.839116f,
146911.942292f,146938.046629f,146964.152125f,146990.258780f,147016.366594f,147042.475568f,147068.585700f,147094.696992f,
147120.809442f,147146.923051f,147173.037819f,147199.153745f,147225.270830f,147251.389073f,147277.508474f,147303.629033f,
147329.750750f,147355.873626f,147381.997659f,147408.122849f,147434.249197f,147460.376703f,147486.505366f,147512.635187f,
147538.766164f,147564.898299f,147591.031591f,147617.166039f,147643.301645f,147669.438407f,147695.576325f,147721.715400f,
147747.855632f,147773.997019f,147800.139563f,147826.283263f,147852.428119f,147878.574131f,147904.721298f,147930.869621f,
147957.019100f,147983.169734f,148009.321523f,148035.474468f,148061.628568f,148087.783823f,148113.940233f,148140.097797f,
148166.256517f,148192.416391f,148218.577419f,148244.739602f,148270.902939f,148297.067431f,148323.233077f,148349.399876f,
148375.567830f,148401.736937f,148427.907198f,148454.078613f,148480.251181f,148506.424903f,148532.599778f,148558.775806f,
148584.952987f,148611.131321f,148637.310808f,148663.491448f,148689.673241f,148715.856186f,148742.040284f,148768.225534f,
148794.411936f,148820.599491f,148846.788198f,148872.978056f,148899.169067f,148925.361229f,148951.554543f,148977.749009f,
149003.944626f,149030.141394f,149056.339314f,149082.538385f,149108.738607f,149134.939980f,149161.142504f,149187.346179f,
149213.551004f,149239.756980f,149265.964106f,149292.172383f,149318.381810f,149344.592387f,149370.804114f,149397.016991f,
149423.231018f,149449.446195f,149475.662522f,149501.879998f,149528.098623f,149554.318398f,149580.539322f,149606.761395f,
149632.984618f,149659.208989f,149685.434509f,149711.661178f,149737.888995f,149764.117961f,149790.348076f,149816.579339f,
149842.811750f,149869.045309f,149895.280017f,149921.515872f,149947.752875f,149973.991026f,150000.230325f,150026.470771f,
150052.712364f,150078.955105f,150105.198993f,150131.444029f,150157.690211f,150183.937540f,150210.186017f,150236.435640f,
150262.686409f,150288.938325f,150315.191388f,150341.445597f,150367.700952f,150393.957453f,150420.215100f,150446.473894f,
150472.733833f,150498.994918f,150525.257148f,150551.520524f,150577.785046f,150604.050713f,150630.317525f,150656.585482f,
150682.854584f,150709.124831f,150735.396224f,150761.668760f,150787.942442f,150814.217268f,150840.493238f,150866.770353f,
150893.048612f,150919.328016f,150945.608563f,150971.890254f,150998.173089f,151024.457068f,151050.742190f,151077.028457f,
151103.315866f,151129.604419f,151155.894115f,151182.184954f,151208.476937f,151234.770062f,151261.064330f,151287.359741f,
151313.656294f,151339.953990f,151366.252829f,151392.552810f,151418.853933f,151445.156198f,151471.459606f,151497.764155f,
151524.069846f,151550.376679f,151576.684654f,151602.993770f,151629.304028f,151655.615427f,151681.927967f,151708.241649f,
151734.556471f,151760.872435f,151787.189539f,151813.507785f,151839.827170f,151866.147697f,151892.469364f,151918.792171f,
151945.116119f,151971.441206f,151997.767434f,152024.094802f,152050.423310f,152076.752957f,152103.083745f,152129.415671f,
152155.748738f,152182.082943f,152208.418288f,152234.754772f,152261.092396f,152287.431158f,152313.771059f,152340.112099f,
152366.454278f,152392.797595f,152419.142051f,152445.487645f,152471.834377f,152498.182248f,152524.531257f,152550.881404f,
152577.232688f,152603.585111f,152629.938671f,152656.293369f,152682.649205f,152709.006177f,152735.364288f,152761.723535f,
152788.083919f,152814.445441f,152840.808100f,152867.171895f,152893.536827f,152919.902896f,152946.270101f,152972.638443f,
152999.007921f,153025.378535f,153051.750285f,153078.123172f,153104.497194f,153130.872353f,153157.248647f,153183.626076f,
153210.004642f,153236.384342f,153262.765178f,153289.147150f,153315.530256f,153341.914498f,153368.299875f,153394.686386f,
153421.074032f,153447.462813f,153473.852729f,153500.243779f,153526.635963f,153553.029282f,153579.423735f,153605.819322f,
153632.216043f,153658.613898f,153685.012887f,153711.413009f,153737.814265f,153764.216655f,153790.620178f,153817.024834f,
153843.430623f,153869.837546f,153896.245602f,153922.654790f,153949.065112f,153975.476566f,154001.889153f,154028.302872f,
154054.717724f,154081.133708f,154107.550825f,154133.969073f,154160.388454f,154186.808966f,154213.230611f,154239.653387f,
154266.077295f,154292.502334f,154318.928505f,154345.355807f,154371.784241f,154398.213806f,154424.644502f,154451.076328f,
154477.509286f,154503.943375f,154530.378594f,154556.814944f,154583.252424f,154609.691035f,154636.130776f,154662.571647f,
154689.013649f,154715.456780f,154741.901041f,154768.346433f,154794.792954f,154821.240604f,154847.689384f,154874.139294f,
154900.590333f,154927.042501f,154953.495798f,154979.950224f,155006.405780f,155032.862464f,155059.320277f,155085.779219f,
155112.239289f,155138.700488f,155165.162815f,155191.626270f,155218.090854f,155244.556565f,155271.023405f,155297.491372f,
155323.960468f,155350.430691f,155376.902042f,155403.374520f,155429.848125f,155456.322858f,155482.798719f,155509.275706f,
155535.753820f,155562.233062f,155588.713430f,155615.194925f,155641.677546f,155668.161295f,155694.646169f,155721.132170f,
155747.619297f,155774.107551f,155800.596930f,155827.087436f,155853.579067f,155880.071824f,155906.565707f,155933.060716f,
155959.556850f,155986.054109f,156012.552494f,156039.052004f,156065.552639f,156092.054399f,156118.557284f,156145.061294f,
156171.566428f,156198.072688f,156224.580072f,156251.088580f,156277.598212f,156304.108969f,156330.620850f,156357.133856f,
156383.647985f,156410.163238f,156436.679614f,156463.197115f,156489.715739f,156516.235487f,156542.756358f,156569.278352f,
156595.801469f,156622.325710f,156648.851074f,156675.377560f,156701.905170f,156728.433902f,156754.963757f,156781.494734f,
156808.026834f,156834.560056f,156861.094401f,156887.629868f,156914.166456f,156940.704167f,156967.243000f,156993.782954f,
157020.324030f,157046.866228f,157073.409547f,157099.953988f,157126.499550f,157153.046233f,157179.594037f,157206.142962f,
157232.693009f,157259.244176f,157285.796464f,157312.349872f,157338.904401f,157365.460051f,157392.016821f,157418.574711f,
157445.133722f,157471.693852f,157498.255103f,157524.817473f,157551.380963f,157577.945573f,157604.511303f,157631.078152f,
157657.646120f,157684.215208f,157710.785415f,157737.356741f,157763.929186f,157790.502751f,157817.077434f,157843.653236f,
157870.230156f,157896.808195f,157923.387353f,157949.967629f,157976.549023f,158003.131536f,158029.715166f,158056.299915f,
158082.885781f,158109.472766f,158136.060868f,158162.650087f,158189.240425f,158215.831879f,158242.424452f,158269.018141f,
158295.612947f,158322.208871f,158348.805912f,158375.404069f,158402.003343f,158428.603734f,158455.205242f,158481.807866f,
158508.411606f,158535.016463f,158561.622436f,158588.229526f,158614.837731f,158641.447052f,158668.057489f,158694.669042f,
158721.281710f,158747.895495f,158774.510394f,158801.126409f,158827.743539f,158854.361785f,158880.981145f,158907.601621f,
158934.223211f,158960.845917f,158987.469737f,159014.094672f,159040.720721f,159067.347885f,159093.976163f,159120.605555f,
159147.236062f,159173.867682f,159200.500417f,159227.134265f,159253.769228f,159280.405304f,159307.042493f,159333.680797f,
159360.320213f,159386.960743f,159413.602386f,159440.245143f,159466.889012f,159493.533994f,159520.180090f,159546.827298f,
159573.475618f,159600.125052f,159626.775597f,159653.427256f,159680.080026f,159706.733909f,159733.388904f,159760.045011f,
159786.702230f,159813.360560f,159840.020003f,159866.680557f,159893.342223f,159920.005000f,159946.668889f,159973.333888f,
160000.000000f,160026.667222f,160053.335555f,160080.004999f,160106.675554f,160133.347220f,160160.019996f,160186.693883f,
160213.368881f,160240.044988f,160266.722206f,160293.400535f,160320.079973f,160346.760521f,160373.442179f,160400.124947f,
160426.808825f,160453.493813f,160480.179910f,160506.867116f,160533.555432f,160560.244857f,160586.935391f,160613.627034f,
160640.319786f,160667.013648f,160693.708618f,160720.404696f,160747.101883f,160773.800179f,160800.499584f,160827.200096f,
160853.901717f,160880.604446f,160907.308283f,160934.013228f,160960.719281f,160987.426442f,161014.134710f,161040.844086f,
161067.554569f,161094.266160f,161120.978859f,161147.692664f,161174.407577f,161201.123597f,161227.840723f,161254.558957f,
161281.278297f,161307.998744f,161334.720298f,161361.442958f,161388.166724f,161414.891597f,161441.617576f,161468.344662f,
161495.072853f,161521.802150f,161548.532553f,161575.264062f,161601.996677f,161628.730397f,161655.465222f,161682.201153f,
161708.938190f,161735.676331f,161762.415578f,161789.155930f,161815.897386f,161842.639948f,161869.383614f,161896.128385f,
161922.874261f,161949.621241f,161976.369326f,162003.118514f,162029.868807f,162056.620205f,162083.372706f,162110.126311f,
162136.881020f,162163.636833f,162190.393749f,162217.151769f,162243.910893f,162270.671120f,162297.432450f,162324.194883f,
162350.958420f,162377.723059f,162404.488802f,162431.255647f,162458.023596f,162484.792646f,162511.562800f,162538.334056f,
162565.106414f,162591.879875f,162618.654437f,162645.430102f,162672.206869f,162698.984738f,162725.763709f,162752.543782f,
162779.324956f,162806.107232f,162832.890609f,162859.675088f,162886.460668f,162913.247349f,162940.035132f,162966.824015f,
162993.614000f,163020.405085f,163047.197271f,163073.990558f,163100.784945f,163127.580433f,163154.377021f,163181.174709f,
163207.973498f,163234.773387f,163261.574376f,163288.376465f,163315.179654f,163341.983942f,163368.789330f,163395.595818f,
163422.403406f,163449.212092f,163476.021878f,163502.832764f,163529.644748f,163556.457832f,163583.272014f,163610.087295f,
163636.903675f,163663.721154f,163690.539732f,163717.359408f,163744.180182f,163771.002055f,163797.825026f,163824.649095f,
163851.474262f,163878.300527f,163905.127890f,163931.956351f,163958.785909f,163985.616565f,164012.448319f,164039.281170f,
164066.115119f,164092.950164f,164119.786307f,164146.623547f,164173.461884f,164200.301318f,164227.141848f,164253.983476f,
164280.826200f,164307.670020f,164334.514937f,164361.360951f,164388.208060f,164415.056266f,164441.905568f,164468.755966f,
164495.607459f,164522.460049f,164549.313734f,164576.168515f,164603.024392f,164629.881364f,164656.739431f,164683.598594f,
164710.458852f,164737.320205f,164764.182653f,164791.046196f,164817.910833f,164844.776566f,164871.643393f,164898.511315f,
164925.380331f,164952.250441f,164979.121646f,165005.993946f,165032.867339f,165059.741826f,165086.617407f,165113.494082f
};	

/* huffman.h  */

static int huffman_decode(int tbl,int *x,int *y);

#define N_CUE 16
#define NC_O  4
 
/* these are the huffman tables, rearranged for lookup
*/
unsigned int h0[1]={0x0};
unsigned int h1[4]={0x311, 0x20000301, 0x40000210, 0x80000100};
unsigned int h2[9]={0x622, 0x4000602, 0x8000512, 0x10000521, 0x18000520, 0x20000311, 0x40000301, 0x60000310,
 0x80000100};
unsigned int h3[9]={ 0x622, 0x4000602, 0x8000512, 0x10000521, 0x18000520, 0x20000310, 0x40000211, 0x80000201,
 0xc0000200};
unsigned int h5[16]={0x833, 0x1000823, 0x2000732, 0x4000631, 0x8000713, 0xa000703, 0xc000730, 0xe000722,
 0x10000612, 0x14000621, 0x18000602, 0x1c000620, 0x20000311, 0x40000301, 0x60000310, 0x80000100};
unsigned int h6[16]={0x733, 0x2000703, 0x4000623, 0x8000632, 0xc000630, 0x10000513, 0x18000531, 0x20000522,
 0x28000502, 0x30000412, 0x40000421, 0x50000420, 0x60000301, 0x80000211, 0xc0000310, 0xe0000300};
unsigned int h7[36]={ 0xa55, 0x400a45, 0x800a54, 0xc00a53, 0x1000935, 0x1800944, 0x2000925, 0x2800952,
 0x3000815, 0x4000851, 0x5000905, 0x5800934, 0x6000850, 0x7000943, 0x7800933, 0x8000824,
 0x9000842, 0xa000714, 0xc000741, 0xe000740, 0x10000804, 0x11000823, 0x12000832, 0x13000803,
 0x14000713, 0x16000731, 0x18000730, 0x1a000722, 0x1c000612, 0x20000521, 0x28000602, 0x2c000620,
 0x30000411, 0x40000301, 0x60000310, 0x80000100};
unsigned int h8[36]={0xb55, 0x200b54, 0x400a45, 0x800953, 0x1000a35, 0x1400a44, 0x1800925, 0x2000952,
 0x2800905, 0x3000815, 0x4000851, 0x5000934, 0x5800943, 0x6000950, 0x6800933, 0x7000824,
 0x8000842, 0x9000814, 0xa000741, 0xc000804, 0xd000840, 0xe000823, 0xf000832, 0x10000813,
 0x11000831, 0x12000803, 0x13000830, 0x14000622, 0x18000602, 0x1c000620, 0x20000412, 0x30000421,
 0x40000211, 0x80000301, 0xa0000310, 0xc0000200};
unsigned int h9[36]={ 0x955, 0x800945, 0x1000835, 0x2000853, 0x3000954, 0x3800905, 0x4000844, 0x5000825,
 0x6000852, 0x7000815, 0x8000751, 0xa000734, 0xc000743, 0xe000850, 0xf000804, 0x10000724,
 0x12000742, 0x14000733, 0x16000740, 0x18000614, 0x1c000641, 0x20000623, 0x24000632, 0x28000513,
 0x30000531, 0x38000603, 0x3c000630, 0x40000522, 0x48000502, 0x50000412, 0x60000421, 0x70000420,
 0x80000311, 0xa0000301, 0xc0000310, 0xe0000300};
unsigned int h10[64]={ 0xb77, 0x200b67, 0x400b76, 0x600b57, 0x800b75, 0xa00b66, 0xc00a47, 0x1000a74,
 0x1400a56, 0x1800a65, 0x1c00a37, 0x2000a73, 0x2400a46, 0x2800b55, 0x2a00b54, 0x2c00a63,
 0x3000927, 0x3800972, 0x4000a64, 0x4400a07, 0x4800970, 0x5000962, 0x5800a45, 0x5c00a35,
 0x6000906, 0x6800a53, 0x6c00a44, 0x7000817, 0x8000871, 0x9000936, 0x9800926, 0xa000a25,
 0xa400a52, 0xa800915, 0xb000951, 0xb800a34, 0xbc00a43, 0xc000816, 0xd000861, 0xe000860,
 0xf000905, 0xf800950, 0x10000924, 0x10800942, 0x11000933, 0x11800904, 0x12000814, 0x13000841,
 0x14000840, 0x15000823, 0x16000832, 0x17000803, 0x18000713, 0x1a000731, 0x1c000730, 0x1e000722,
 0x20000612, 0x24000621, 0x28000602, 0x2c000620, 0x30000411, 0x40000301, 0x60000310, 0x80000100};
unsigned int h11[64]={ 0xa77, 0x400a67, 0x800a76, 0xc00a75, 0x1000a66, 0x1400a47, 0x1800a74, 0x1c00b57,
 0x1e00b55, 0x2000a56, 0x2400a65, 0x2800937, 0x3000973, 0x3800946, 0x4000a45, 0x4400a54,
 0x4800a35, 0x4c00a53, 0x5000827, 0x6000872, 0x7000964, 0x7800907, 0x8000771, 0xa000817,
 0xb000870, 0xc000836, 0xd000863, 0xe000860, 0xf000944, 0xf800925, 0x10000952, 0x10800905,
 0x11000815, 0x12000762, 0x14000826, 0x15000806, 0x16000716, 0x18000761, 0x1a000851, 0x1b000834,
 0x1c000850, 0x1d000943, 0x1d800933, 0x1e000824, 0x1f000842, 0x20000814, 0x21000841, 0x22000804,
 0x23000840, 0x24000723, 0x26000732, 0x28000613, 0x2c000631, 0x30000703, 0x32000730, 0x34000622,
 0x38000521, 0x40000412, 0x50000502, 0x58000520, 0x60000311, 0x80000301, 0xa0000310, 0xc0000200};
unsigned int h12[64]={ 0xa77, 0x400a67, 0x800976, 0x1000957, 0x1800975, 0x2000966, 0x2800947, 0x3000974,
 0x3800965, 0x4000856, 0x5000837, 0x6000973, 0x6800955, 0x7000827, 0x8000872, 0x9000846,
 0xa000864, 0xb000817, 0xc000871, 0xd000907, 0xd800970, 0xe000836, 0xf000863, 0x10000845,
 0x11000854, 0x12000844, 0x13000906, 0x13800905, 0x14000726, 0x16000762, 0x18000761, 0x1a000816,
 0x1b000860, 0x1c000835, 0x1d000853, 0x1e000825, 0x1f000852, 0x20000715, 0x22000751, 0x24000734,
 0x26000743, 0x28000850, 0x29000804, 0x2a000724, 0x2c000742, 0x2e000714, 0x30000633, 0x34000641,
 0x38000623, 0x3c000632, 0x40000740, 0x42000703, 0x44000630, 0x48000513, 0x50000531, 0x58000522,
 0x60000412, 0x70000421, 0x80000502, 0x88000520, 0x90000400, 0xa0000311, 0xc0000301, 0xe0000310};
unsigned int h13[256]={
 0x13fe, 0x33fc, 0x52fd, 0x91ed, 0x110ff, 0x210ef, 0x310df, 0x410ee,
 0x510cf, 0x610de, 0x710bf, 0x810fb, 0x910ce, 0xa10dc, 0xb11af, 0xb91e9,
 0xc0fec, 0xe0fdd, 0x1010fa, 0x1110cd, 0x120fbe, 0x140feb, 0x160f9f, 0x180ff9,
 0x1a0fea, 0x1c0fbd, 0x1e0fdb, 0x200f8f, 0x220ff8, 0x240fcc, 0x2610ae, 0x27109e,
 0x280f8e, 0x2a107f, 0x2b107e, 0x2c0ef7, 0x300eda, 0x340fad, 0x360fbc, 0x380fcb,
 0x3a0ff6, 0x3c0e6f, 0x400ee8, 0x440e5f, 0x480e9d, 0x4c0ed9, 0x500ef5, 0x540ee7,
 0x580eac, 0x5c0ebb, 0x600e4f, 0x640ef4, 0x680fca, 0x6a0fe6, 0x6c0ef3, 0x700d3f,
 0x780e8d, 0x7c0ed8, 0x800d2f, 0x880df2, 0x900e6e, 0x940e9c, 0x980d0f, 0xa00ec9,
 0xa40e5e, 0xa80dab, 0xb00e7d, 0xb40ed7, 0xb80d4e, 0xc00ec8, 0xc40ed6, 0xc80d3e,
 0xd00db9, 0xd80e9b, 0xdc0eaa, 0xe00c1f, 0xf00cf1, 0x1000cf0, 0x1100dba, 0x1180de5,
 0x1200de4, 0x1280d8c, 0x1300d6d, 0x1380de3, 0x1400ce2, 0x1500d2e, 0x1580d0e, 0x1600c1e,
 0x1700ce1, 0x1800de0, 0x1880d5d, 0x1900dd5, 0x1980d7c, 0x1a00dc7, 0x1a80d4d, 0x1b00d8b,
 0x1b80db8, 0x1c00dd4, 0x1c80d9a, 0x1d00da9, 0x1d80d6c, 0x1e00cc6, 0x1f00c3d, 0x2000dd3,
 0x2080d7b, 0x2100c2d, 0x2200cd2, 0x2300c1d, 0x2400cb7, 0x2500d5c, 0x2580dc5, 0x2600d99,
 0x2680d7a, 0x2700cc3, 0x2800da7, 0x2880d97, 0x2900c4b, 0x2a00bd1, 0x2c00c0d, 0x2d00cd0,
 0x2e00c8a, 0x2f00ca8, 0x3000c4c, 0x3100cc4, 0x3200c6b, 0x3300cb6, 0x3400b3c, 0x3600b2c,
 0x3800bc2, 0x3a00b5b, 0x3c00cb5, 0x3d00c89, 0x3e00b1c, 0x4000bc1, 0x4200c98, 0x4300c0c,
 0x4400bc0, 0x4600cb4, 0x4700c6a, 0x4800ca6, 0x4900c79, 0x4a00b3b, 0x4c00bb3, 0x4e00c88,
 0x4f00c5a, 0x5000b2b, 0x5200ca5, 0x5300c69, 0x5400ba4, 0x5600c78, 0x5700c87, 0x5800b94,
 0x5a00c77, 0x5b00c76, 0x5c00ab2, 0x6000a1b, 0x6400ab1, 0x6800b0b, 0x6a00bb0, 0x6c00b96,
 0x6e00b4a, 0x7000b3a, 0x7200ba3, 0x7400b59, 0x7600b95, 0x7800a2a, 0x7c00aa2, 0x8000a1a,
 0x8400aa1, 0x8800b0a, 0x8a00b68, 0x8c00aa0, 0x9000b86, 0x9200b49, 0x9400a93, 0x9800b39,
 0x9a00b58, 0x9c00b85, 0x9e00b67, 0xa000a29, 0xa400a92, 0xa800b57, 0xaa00b75, 0xac00a38,
 0xb000a83, 0xb400b66, 0xb600b47, 0xb800b74, 0xba00b56, 0xbc00b65, 0xbe00b73, 0xc000919,
 0xc800991, 0xd000a09, 0xd400a90, 0xd800a48, 0xdc00a84, 0xe000a72, 0xe400b46, 0xe600b64,
 0xe800928, 0xf000982, 0xf800918, 0x10000a37, 0x10400a27, 0x10800917, 0x11000971, 0x11800a55,
 0x11c00a07, 0x12000a70, 0x12400a36, 0x12800a63, 0x12c00a45, 0x13000a54, 0x13400a26, 0x13800a62,
 0x13c00a35, 0x14000881, 0x15000908, 0x15800980, 0x16000916, 0x16800961, 0x17000906, 0x17800960,
 0x18000a53, 0x18400a44, 0x18800925, 0x19000952, 0x19800905, 0x1a000815, 0x1b000851, 0x1c000934,
 0x1c800943, 0x1d000950, 0x1d800924, 0x1e000942, 0x1e800933, 0x1f000814, 0x20000741, 0x22000804,
 0x23000840, 0x24000823, 0x25000832, 0x26000713, 0x28000731, 0x2a000703, 0x2c000730, 0x2e000722,
 0x30000612, 0x34000621, 0x38000602, 0x3c000620, 0x40000411, 0x50000401, 0x60000310, 0x80000100};
unsigned int h15[256]={ 0xdff, 0x80def, 0x100dfe, 0x180ddf, 0x200cee, 0x300dfd, 0x380dcf, 0x400dfc,
 0x480dde, 0x500ded, 0x580dbf, 0x600cfb, 0x700dce, 0x780dec, 0x800cdd, 0x900caf,
 0xa00cfa, 0xb00cbe, 0xc00ceb, 0xd00ccd, 0xe00cdc, 0xf00c9f, 0x1000cf9, 0x1100cea,
 0x1200cbd, 0x1300cdb, 0x1400c8f, 0x1500cf8, 0x1600ccc, 0x1700c9e, 0x1800ce9, 0x1900c7f,
 0x1a00cf7, 0x1b00cad, 0x1c00cda, 0x1d00cbc, 0x1e00c6f, 0x1f00dae, 0x1f80d0f, 0x2000bcb,
 0x2200bf6, 0x2400c8e, 0x2500ce8, 0x2600c5f, 0x2700c9d, 0x2800bf5, 0x2a00b7e, 0x2c00be7,
 0x2e00bac, 0x3000bca, 0x3200bbb, 0x3400cd9, 0x3500c8d, 0x3600b4f, 0x3800bf4, 0x3a00b3f,
 0x3c00bf3, 0x3e00bd8, 0x4000be6, 0x4200b2f, 0x4400bf2, 0x4600c6e, 0x4700cf0, 0x4800b1f,
 0x4a00bf1, 0x4c00b9c, 0x4e00bc9, 0x5000b5e, 0x5200bab, 0x5400bba, 0x5600be5, 0x5800b7d,
 0x5a00bd7, 0x5c00b4e, 0x5e00be4, 0x6000b8c, 0x6200bc8, 0x6400b3e, 0x6600b6d, 0x6800bd6,
 0x6a00be3, 0x6c00b9b, 0x6e00bb9, 0x7000b2e, 0x7200baa, 0x7400be2, 0x7600b1e, 0x7800be1,
 0x7a00c0e, 0x7b00ce0, 0x7c00b5d, 0x7e00bd5, 0x8000b7c, 0x8200bc7, 0x8400b4d, 0x8600b8b,
 0x8800ad4, 0x8c00bb8, 0x8e00b9a, 0x9000ba9, 0x9200b6c, 0x9400bc6, 0x9600b3d, 0x9800ad3,
 0x9c00ad2, 0xa000b2d, 0xa200b0d, 0xa400a1d, 0xa800a7b, 0xac00ab7, 0xb000ad1, 0xb400b5c,
 0xb600bd0, 0xb800ac5, 0xbc00a8a, 0xc000aa8, 0xc400a4c, 0xc800ac4, 0xcc00a6b, 0xd000ab6,
 0xd400b99, 0xd600b0c, 0xd800a3c, 0xdc00ac3, 0xe000a7a, 0xe400aa7, 0xe800aa6, 0xec00bc0,
 0xee00b0b, 0xf0009c2, 0xf800a2c, 0xfc00a5b, 0x10000ab5, 0x10400a1c, 0x10800a89, 0x10c00a98,
 0x11000ac1, 0x11400a4b, 0x11800ab4, 0x11c00a6a, 0x12000a3b, 0x12400a79, 0x128009b3, 0x13000a97,
 0x13400a88, 0x13800a2b, 0x13c00a5a, 0x140009b2, 0x14800aa5, 0x14c00a1b, 0x150009b1, 0x15800ab0,
 0x15c00a69, 0x16000a96, 0x16400a4a, 0x16800aa4, 0x16c00a78, 0x17000a87, 0x17400a3a, 0x178009a3,
 0x18000959, 0x18800995, 0x1900092a, 0x198009a2, 0x1a00091a, 0x1a8009a1, 0x1b000a0a, 0x1b400aa0,
 0x1b800968, 0x1c000986, 0x1c800949, 0x1d000994, 0x1d800939, 0x1e000993, 0x1e800a77, 0x1ec00a09,
 0x1f000958, 0x1f800985, 0x20000929, 0x20800967, 0x21000976, 0x21800992, 0x22000891, 0x23000919,
 0x23800990, 0x24000948, 0x24800984, 0x25000957, 0x25800975, 0x26000938, 0x26800983, 0x27000966,
 0x27800947, 0x28000828, 0x29000882, 0x2a000818, 0x2b000881, 0x2c000974, 0x2c800908, 0x2d000980,
 0x2d800956, 0x2e000965, 0x2e800937, 0x2f000973, 0x2f800946, 0x30000827, 0x31000872, 0x32000864,
 0x33000817, 0x34000855, 0x35000871, 0x36000907, 0x36800970, 0x37000836, 0x38000863, 0x39000845,
 0x3a000854, 0x3b000826, 0x3c000862, 0x3d000816, 0x3e000906, 0x3e800960, 0x3f000835, 0x40000761,
 0x42000853, 0x43000844, 0x44000725, 0x46000752, 0x48000715, 0x4a000751, 0x4c000805, 0x4d000850,
 0x4e000734, 0x50000743, 0x52000724, 0x54000742, 0x56000733, 0x58000641, 0x5c000714, 0x5e000704,
 0x60000623, 0x64000632, 0x68000740, 0x6a000703, 0x6c000613, 0x70000631, 0x74000630, 0x78000522,
 0x80000512, 0x88000521, 0x90000502, 0x98000520, 0xa0000311, 0xc0000401, 0xd0000410, 0xe0000300};
unsigned int h16[256]={ 0xbef, 0x200bfe, 0x400bdf, 0x600bfd, 0x800bcf, 0xa00bfc, 0xc00bbf, 0xe00bfb,
 0x1000aaf, 0x1400bfa, 0x1600b9f, 0x1800bf9, 0x1a00bf8, 0x1c00a8f, 0x2000a7f, 0x2400af7,
 0x2800a6f, 0x2c00af6, 0x30008ff, 0x4000a5f, 0x4400af5, 0x480094f, 0x50009f4, 0x58009f3,
 0x60009f0, 0x6800a3f, 0x6c010ce, 0x6c111ec, 0x6c191dd, 0x6c20fde, 0x6c40fe9, 0x6c610ea,
 0x6c710d9, 0x6c80eee, 0x6cc0fed, 0x6ce0feb, 0x6d00ebe, 0x6d40ecd, 0x6d80fdc, 0x6da0fdb,
 0x6dc0eae, 0x6e00ecc, 0x6e40fad, 0x6e60fda, 0x6e80f7e, 0x6ea0fac, 0x6ec0eca, 0x6f00fc9,
 0x6f20f7d, 0x6f40e5e, 0x6f80dbd, 0x70008f2, 0x800092f, 0x880090f, 0x900081f, 0xa0008f1,
 0xb000d9e, 0xb080ebc, 0xb0c0ecb, 0xb100e8e, 0xb140ee8, 0xb180e9d, 0xb1c0ee7, 0xb200ebb,
 0xb240e8d, 0xb280ed8, 0xb2c0e6e, 0xb300de6, 0xb380d9c, 0xb400eab, 0xb440eba, 0xb480ee5,
 0xb4c0ed7, 0xb500d4e, 0xb580ee4, 0xb5c0e8c, 0xb600dc8, 0xb680d3e, 0xb700d6d, 0xb780ed6,
 0xb7c0e9b, 0xb800eb9, 0xb840eaa, 0xb880de1, 0xb900dd4, 0xb980eb8, 0xb9c0ea9, 0xba00d7b,
 0xba80eb7, 0xbac0ed0, 0xbb00ce3, 0xbc00d0e, 0xbc80de0, 0xbd00d5d, 0xbd80dd5, 0xbe00d7c,
 0xbe80dc7, 0xbf00d4d, 0xbf80d8b, 0xc000d9a, 0xc080d6c, 0xc100dc6, 0xc180d3d, 0xc200d5c,
 0xc280dc5, 0xc300c0d, 0xc400d8a, 0xc480da8, 0xc500d99, 0xc580d4c, 0xc600db6, 0xc680d7a,
 0xc700c3c, 0xc800d5b, 0xc880d89, 0xc900c1c, 0xca00cc0, 0xcb00d98, 0xcb80d79, 0xcc00be2,
 0xce00c2e, 0xcf00c1e, 0xd000cd3, 0xd100c2d, 0xd200cd2, 0xd300cd1, 0xd400c3b, 0xd500d97,
 0xd580d88, 0xd600b1d, 0xd800cc4, 0xd900c6b, 0xda00cc3, 0xdb00ca7, 0xdc00b2c, 0xde00cc2,
 0xdf00cb5, 0xe000cc1, 0xe100c0c, 0xe200c4b, 0xe300cb4, 0xe400c6a, 0xe500ca6, 0xe600bb3,
 0xe800c5a, 0xe900ca5, 0xea00b2b, 0xec00bb2, 0xee00b1b, 0xf000bb1, 0xf200c0b, 0xf300cb0,
 0xf400c69, 0xf500c96, 0xf600c4a, 0xf700ca4, 0xf800c78, 0xf900c87, 0xfa00ba3, 0xfc00c3a,
  0xfd00c59, 0xfe00b2a, 0x10000c95, 0x10100c68, 0x10200ba1, 0x10400c86, 0x10500c77, 0x10600b94,
 0x10800c49, 0x10900c57, 0x10a00b67, 0x10c00aa2, 0x11000a1a, 0x11400b0a, 0x11600ba0, 0x11800b39,
 0x11a00b93, 0x11c00b58, 0x11e00b85, 0x12000a29, 0x12400a92, 0x12800b76, 0x12a00b09, 0x12c00a19,
 0x13000a91, 0x13400b90, 0x13600b48, 0x13800b84, 0x13a00b75, 0x13c00b38, 0x13e00b83, 0x14000b66,
 0x14200b28, 0x14400a82, 0x14800b47, 0x14a00b74, 0x14c00a18, 0x15000a81, 0x15400a80, 0x15800b08,
 0x15a00b56, 0x15c00a37, 0x16000a73, 0x16400b65, 0x16600b46, 0x16800a27, 0x16c00a72, 0x17000b64,
 0x17200b55, 0x17400a07, 0x17800917, 0x18000971, 0x18800a70, 0x18c00a36, 0x19000a63, 0x19400a45,
 0x19800a54, 0x19c00a26, 0x1a000962, 0x1a800916, 0x1b000961, 0x1b800a06, 0x1bc00a60, 0x1c000953,
 0x1c800a35, 0x1cc00a44, 0x1d000925, 0x1d800952, 0x1e000851, 0x1f000915, 0x1f800905, 0x20000934,
 0x20800943, 0x21000950, 0x21800924, 0x22000942, 0x22800933, 0x23000814, 0x24000841, 0x25000904,
 0x25800940, 0x26000823, 0x27000832, 0x28000713, 0x2a000731, 0x2c000803, 0x2d000830, 0x2e000722,
 0x30000612, 0x34000621, 0x38000602, 0x3c000620, 0x40000411, 0x50000401, 0x60000310, 0x80000100};
unsigned int h24[256]={ 0x8ef, 0x10008fe, 0x20008df, 0x30008fd, 0x40008cf, 0x50008fc, 0x60008bf, 0x70008fb,
 0x80007fa, 0xa0008af, 0xb00089f, 0xc0007f9, 0xe0007f8, 0x1000088f, 0x1100087f, 0x120007f7,
 0x1400076f, 0x160007f6, 0x1800075f, 0x1a0007f5, 0x1c00074f, 0x1e0007f4, 0x2000073f, 0x220007f3,
 0x2400072f, 0x260007f2, 0x280007f1, 0x2a00081f, 0x2b0008f0, 0x2c00090f, 0x2c800bee, 0x2ca00bde,
 0x2cc00bed, 0x2ce00bce, 0x2d000bec, 0x2d200bdd, 0x2d400bbe, 0x2d600beb, 0x2d800bcd, 0x2da00bdc,
 0x2dc00bae, 0x2de00bea, 0x2e000bbd, 0x2e200bdb, 0x2e400bcc, 0x2e600b9e, 0x2e800be9, 0x2ea00bad,
 0x2ec00bda, 0x2ee00bbc, 0x2f000bcb, 0x2f200b8e, 0x2f400be8, 0x2f600b9d, 0x2f800bd9, 0x2fa00b7e,
 0x2fc00be7, 0x2fe00bac, 0x300004ff, 0x40000bca, 0x40200bbb, 0x40400b8d, 0x40600bd8, 0x40800c0e,
 0x40900ce0, 0x40a00b0d, 0x40c00ae6, 0x41000b6e, 0x41200b9c, 0x41400ac9, 0x41800a5e, 0x41c00aba,
 0x42000ae5, 0x42400bab, 0x42600b7d, 0x42800ad7, 0x42c00ae4, 0x43000a8c, 0x43400ac8, 0x43800b4e,
 0x43a00b2e, 0x43c00a3e, 0x44000a6d, 0x44400ad6, 0x44800ae3, 0x44c00a9b, 0x45000ab9, 0x45400aaa,
 0x45800ae2, 0x45c00a1e, 0x46000ae1, 0x46400a5d, 0x46800ad5, 0x46c00a7c, 0x47000ac7, 0x47400a4d,
 0x47800a8b, 0x47c00ab8, 0x48000ad4, 0x48400a9a, 0x48800aa9, 0x48c00a6c, 0x49000ac6, 0x49400a3d,
 0x49800ad3, 0x49c00a2d, 0x4a000ad2, 0x4a400a1d, 0x4a800a7b, 0x4ac00ab7, 0x4b000ad1, 0x4b400a5c,
 0x4b800ac5, 0x4bc00a8a, 0x4c000aa8, 0x4c400a99, 0x4c800a4c, 0x4cc00ac4, 0x4d000a6b, 0x4d400ab6,
 0x4d800bd0, 0x4da00b0c, 0x4dc00a3c, 0x4e000ac3, 0x4e400a7a, 0x4e800aa7, 0x4ec00a2c, 0x4f000ac2,
 0x4f400a5b, 0x4f800ab5, 0x4fc00a1c, 0x50000a89, 0x50400a98, 0x50800ac1, 0x50c00a4b, 0x51000bc0,
 0x51200b0b, 0x51400a3b, 0x51800bb0, 0x51a00b0a, 0x51c00a1a, 0x520009b4, 0x52800a6a, 0x52c00aa6,
 0x53000a79, 0x53400a97, 0x53800ba0, 0x53a00b09, 0x53c00a90, 0x540009b3, 0x54800988, 0x55000a2b,
 0x55400a5a, 0x558009b2, 0x56000aa5, 0x56400a1b, 0x56800ab1, 0x56c00a69, 0x57000996, 0x578009a4,
 0x58000a4a, 0x58400a78, 0x58800987, 0x5900093a, 0x598009a3, 0x5a000959, 0x5a800995, 0x5b00092a,
  0x5b8009a2, 0x5c0009a1, 0x5c800968, 0x5d000986, 0x5d800977, 0x5e000949, 0x5e800994, 0x5f000939,
 0x5f800993, 0x60000958, 0x60800985, 0x61000929, 0x61800967, 0x62000976, 0x62800992, 0x63000919,
 0x63800991, 0x64000948, 0x64800984, 0x65000957, 0x65800975, 0x66000938, 0x66800983, 0x67000966,
 0x67800928, 0x68000982, 0x68800918, 0x69000947, 0x69800974, 0x6a000981, 0x6a800a08, 0x6ac00a80,
 0x6b000956, 0x6b800965, 0x6c000917, 0x6c800a07, 0x6cc00a70, 0x6d000873, 0x6e000937, 0x6e800927,
 0x6f000872, 0x70000846, 0x71000864, 0x72000855, 0x73000871, 0x74000836, 0x75000863, 0x76000845,
 0x77000854, 0x78000826, 0x79000862, 0x7a000816, 0x7b000861, 0x7c000906, 0x7c800960, 0x7d000835,
 0x7e000853, 0x7f000844, 0x80000825, 0x81000852, 0x82000815, 0x83000905, 0x83800950, 0x84000751,
 0x86000834, 0x87000843, 0x88000724, 0x8a000742, 0x8c000733, 0x8e000714, 0x90000741, 0x92000804,
 0x93000840, 0x94000723, 0x96000732, 0x98000613, 0x9c000631, 0xa0000703, 0xa2000730, 0xa4000622,
 0xa8000512, 0xb0000521, 0xb8000602, 0xbc000620, 0xc0000411, 0xd0000401, 0xe0000410, 0xf0000400};
unsigned int hA[16]={ 0x6b0, 0x40006f0, 0x80006d0, 0xc0006e0, 0x10000670, 0x14000650, 0x18000590, 0x20000560,
 0x28000530, 0x300005a0, 0x380005c0, 0x40000420, 0x50000410, 0x60000440, 0x70000480, 0x80000100};
unsigned int hB[16]={  0x4f0, 0x100004e0, 0x200004d0, 0x300004c0, 0x400004b0, 0x500004a0, 0x60000490, 0x70000480,
 0x80000470, 0x90000460, 0xa0000450, 0xb0000440, 0xc0000430, 0xd0000420, 0xe0000410, 0xf0000400};

/* now the cues, remember to change these tables if you change N_CUE
*/
unsigned char h_cue[34][N_CUE]={
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3},
{0,3,5,5,6,6,7,7,8,8,8,8,8,8,8,8},
{0,3,5,5,6,6,6,6,7,7,7,7,8,8,8,8},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,8,12,12,13,13,14,14,15,15,15,15,15,15,15,15},
{0,5,7,9,10,11,12,12,13,13,13,13,14,14,15,15},
{0,20,29,32,33,33,34,34,35,35,35,35,35,35,35,35},
{0,23,30,31,32,32,32,32,33,33,34,34,35,35,35,35},
{0,15,21,24,27,29,30,31,32,32,33,33,34,34,35,35},
{0,42,56,60,61,61,62,62,63,63,63,63,63,63,63,63},
{0,30,45,53,57,58,60,60,61,61,62,62,63,63,63,63},
{0,23,37,46,50,54,56,57,58,60,61,61,62,62,63,63},
{0,203,238,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,132,178,205,223,233,240,245,248,250,252,252,253,254,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,162,231,248,252,253,254,254,255,255,255,255,255,255,255,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,13,22,58,59,131,177,209,226,238,245,249,252,253,254,255},
{0,4,7,9,11,12,13,14,15,15,15,15,15,15,15,15},
{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15}
};

/* hmmm, a sto sa h4 i h14, preslikati ih u h5/h15
*/
unsigned int *tables[34]={h0,h1,h2,h3,0,h5,h6,h7,h8,h9,h10,h11,h12,h13,0,h15,
	h16,h16,h16,h16,h16,h16,h16,h16,h24,h24,h24,h24,h24,h24,h24,h24,hA,hB};

/* transform.h */

static void imdct_init();
void imdct(int win_type,int sb,int ch);
void poly(mp3Info *ext, const int ch, int i);
static void premultiply();

float stereo_samples[18][32][2];
float mono_samples[18][32];
float s[2][32][18];
float res[32][18];
float win[4][36];

static const float t_sin[4][36]={{
   -0.032160f,    0.103553f,   -0.182543f,    0.266729f,   -0.353554f,    0.440377f,
   -0.524563f,    0.603553f,   -0.674947f,    0.736575f,   -0.786566f,    0.823400f,
   -0.845957f,    0.853554f,   -0.845957f,    0.823399f,   -0.786566f,    0.736575f,
   -0.674947f,    0.603553f,   -0.524564f,    0.440378f,   -0.353553f,    0.266729f,
   -0.182544f,    0.103553f,   -0.032160f,   -0.029469f,    0.079459f,   -0.116293f,
    0.138851f,   -0.146446f,    0.138851f,   -0.116293f,    0.079459f,   -0.029469f
},{
   -0.032160f,    0.103553f,   -0.182543f,    0.266729f,   -0.353554f,    0.440377f,
   -0.524563f,    0.603553f,   -0.674947f,    0.736575f,   -0.786566f,    0.823400f,
   -0.845957f,    0.853554f,   -0.845957f,    0.823399f,   -0.786566f,    0.736575f,
   -0.675590f,    0.608761f,   -0.537300f,    0.461749f,   -0.382683f,    0.300706f,
   -0.214588f,    0.120590f,   -0.034606f,   -0.026554f,    0.049950f,   -0.028251f,
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f
},{
   -0.103553f,    0.353554f,   -0.603553f,    0.786566f,   -0.853554f,    0.786566f,
   -0.603553f,    0.353553f,   -0.103553f,   -0.079459f,    0.146446f,   -0.079459f,
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f
},{
    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,    0.000000f,
   -0.127432f,    0.379410f,   -0.608182f,    0.792598f,   -0.915976f,    0.967944f,
   -0.953717f,    0.923880f,   -0.887011f,    0.843391f,   -0.793353f,    0.737277f,
   -0.674947f,    0.603553f,   -0.524564f,    0.440378f,   -0.353553f,    0.266729f,
   -0.182544f,    0.103553f,   -0.032160f,   -0.029469f,    0.079459f,   -0.116293f,
    0.138851f,   -0.146446f,    0.138851f,   -0.116293f,    0.079459f,   -0.029469f
}};

static const float t_2cos[4][18]={
{ -0.174311f,  -0.517638f,  -0.845237f,  -1.147153f,
  -1.414214f,  -1.638304f, -1.812616f,  -1.931852f,
  -1.992389f,   0.174311f,   0.517638f,   0.845237f,
   1.147153f,   1.414214f,   1.638304f, 1.812616f,
   1.931852f,   1.992389f},
{ -0.174311f,  -0.517638f,  -0.845237f,  -1.147153f,
  -1.414214f,  -1.638304f, -1.812616f,  -1.931852f,
  -1.992389f,   0.174311f,   0.517638f,   0.845237f,
   1.147153f,   1.414214f,   1.638304f, 1.812616f,
   1.931852f,   1.992389f},
{ -0.517638f, -1.41421f, -1.93185f, 0.517638f, 1.41421f
    , 1.93185f,.0f,.0f,.0f,.0f,.0f,.0f,.0f,.0f,.0f,.0f,.0f,.0f},
{ -0.174311f,  -0.517638f,  -0.845237f,  -1.147153f,
  -1.414214f,  -1.638304f, -1.812616f,  -1.931852f,  -1.992389f,
   0.174311f,   0.517638f,   0.845237f,   1.147153f,
   1.414214f,   1.638304f, 1.812616f,   1.931852f,   1.992389f}
};

static const float b1 = 1.997590912f;
static const float b2 = 1.990369453f;
static const float b3 = 1.978353019f;
static const float b4 = 1.961570560f;
static const float b5 = 1.940062506f;
static const float b6 = 1.913880671f;
static const float b7 = 1.883088130f;
static const float b8 = 1.847759065f;
static const float b9 = 1.807978586f;
static const float b10= 1.763842529f;
static const float b11= 1.715457220f;
static const float b12= 1.662939225f;
static const float b13= 1.606415063f;
static const float b14= 1.546020907f;
static const float b15= 1.481902251f;
static const float b16= 1.414213562f;
static const float b17= 1.343117910f;
static const float b18= 1.268786568f;
static const float b19= 1.191398609f;
static const float b20= 1.111140466f;
static const float b21= 1.028205488f;
static const float b22= 0.942793474f;
static const float b23= 0.855110187f;
static const float b24= 0.765366865f;
static const float b25= 0.673779707f;
static const float b26= 0.580569355f;
static const float b27= 0.485960360f;
static const float b28= 0.390180644f;
static const float b29= 0.293460949f;
static const float b30= 0.196034281f;
static const float b31= 0.098135349f;

static float t_dewindow[16][32] = {
{0.000000000f ,-0.000442505f , 0.003250122f ,-0.007003784f , 0.031082153f ,-0.078628540f , 0.100311279f ,-0.572036743f ,
 1.144989014f , 0.572036743f , 0.100311279f , 0.078628540f , 0.031082153f , 0.007003784f , 0.003250122f , 0.000442505f ,
-0.000015259f ,-0.000473022f , 0.003326416f ,-0.007919312f , 0.030517578f ,-0.084182739f , 0.090927124f ,-0.600219727f ,
 1.144287109f , 0.543823242f , 0.108856201f , 0.073059082f , 0.031478882f , 0.006118774f , 0.003173828f , 0.000396729f },

{-0.000015259f ,-0.000534058f , 0.003387451f ,-0.008865356f , 0.029785156f ,-0.089706421f , 0.080688477f ,-0.628295898f ,
 1.142211914f , 0.515609741f , 0.116577148f , 0.067520142f , 0.031738281f , 0.005294800f , 0.003082275f , 0.000366211f ,
-0.000015259f ,-0.000579834f , 0.003433228f ,-0.009841919f , 0.028884888f ,-0.095169067f , 0.069595337f ,-0.656219482f ,
 1.138763428f , 0.487472534f , 0.123474121f , 0.061996460f , 0.031845093f , 0.004486084f , 0.002990723f , 0.000320435f },

{-0.000015259f ,-0.000625610f , 0.003463745f ,-0.010848999f , 0.027801514f ,-0.100540161f , 0.057617187f ,-0.683914185f ,
 1.133926392f , 0.459472656f , 0.129577637f , 0.056533813f , 0.031814575f , 0.003723145f , 0.002899170f , 0.000289917f ,
-0.000015259f ,-0.000686646f , 0.003479004f ,-0.011886597f , 0.026535034f ,-0.105819702f , 0.044784546f ,-0.711318970f ,
 1.127746582f , 0.431655884f , 0.134887695f , 0.051132202f , 0.031661987f , 0.003005981f , 0.002792358f , 0.000259399f },

{-0.000015259f ,-0.000747681f , 0.003479004f ,-0.012939453f , 0.025085449f ,-0.110946655f , 0.031082153f ,-0.738372803f ,
 1.120223999f , 0.404083252f , 0.139450073f , 0.045837402f , 0.031387329f , 0.002334595f , 0.002685547f , 0.000244141f ,
-0.000030518f ,-0.000808716f , 0.003463745f ,-0.014022827f , 0.023422241f ,-0.115921021f , 0.016510010f ,-0.765029907f ,
 1.111373901f , 0.376800537f , 0.143264771f , 0.040634155f , 0.031005859f , 0.001693726f , 0.002578735f , 0.000213623f },

{-0.000030518f ,-0.000885010f , 0.003417969f ,-0.015121460f , 0.021575928f ,-0.120697021f , 0.001068115f ,-0.791213989f ,
 1.101211548f , 0.349868774f , 0.146362305f , 0.035552979f , 0.030532837f , 0.001098633f , 0.002456665f , 0.000198364f ,
-0.000030518f ,-0.000961304f , 0.003372192f ,-0.016235352f , 0.019531250f ,-0.125259399f ,-0.015228271f ,-0.816864014f ,
 1.089782715f , 0.323318481f , 0.148773193f , 0.030609131f , 0.029937744f , 0.000549316f , 0.002349854f , 0.000167847f },

{-0.000030518f ,-0.001037598f , 0.003280640f ,-0.017349243f , 0.017257690f ,-0.129562378f ,-0.032379150f ,-0.841949463f ,
 1.077117920f , 0.297210693f , 0.150497437f , 0.025817871f , 0.029281616f , 0.000030518f , 0.002243042f , 0.000152588f ,
-0.000045776f ,-0.001113892f , 0.003173828f ,-0.018463135f , 0.014801025f ,-0.133590698f ,-0.050354004f ,-0.866363525f ,
 1.063217163f , 0.271591187f , 0.151596069f , 0.021179199f , 0.028533936f ,-0.000442505f , 0.002120972f , 0.000137329f },

{-0.000045776f ,-0.001205444f , 0.003051758f ,-0.019577026f , 0.012115479f ,-0.137298584f ,-0.069168091f ,-0.890090942f ,
 1.048156738f , 0.246505737f , 0.152069092f , 0.016708374f , 0.027725220f ,-0.000869751f , 0.002014160f , 0.000122070f ,
-0.000061035f ,-0.001296997f , 0.002883911f ,-0.020690918f , 0.009231567f ,-0.140670776f ,-0.088775635f ,-0.913055420f ,
 1.031936646f , 0.221984863f , 0.151962280f , 0.012420654f , 0.026840210f ,-0.001266479f , 0.001907349f , 0.000106812f },

{-0.000061035f ,-0.001388550f , 0.002700806f ,-0.021789551f , 0.006134033f ,-0.143676758f ,-0.109161377f ,-0.935195923f ,
 1.014617920f , 0.198059082f , 0.151306152f , 0.008316040f , 0.025909424f ,-0.001617432f , 0.001785278f , 0.000106812f ,
-0.000076294f ,-0.001480103f , 0.002487183f ,-0.022857666f , 0.002822876f ,-0.146255493f ,-0.130310059f ,-0.956481934f ,
 0.996246338f , 0.174789429f , 0.150115967f , 0.004394531f , 0.024932861f ,-0.001937866f , 0.001693726f , 0.000091553f },

{-0.000076294f ,-0.001586914f , 0.002227783f ,-0.023910522f ,-0.000686646f ,-0.148422241f ,-0.152206421f ,-0.976852417f ,
 0.976852417f , 0.152206421f , 0.148422241f , 0.000686646f , 0.023910522f ,-0.002227783f , 0.001586914f , 0.000076294f ,
-0.000091553f ,-0.001693726f , 0.001937866f ,-0.024932861f ,-0.004394531f ,-0.150115967f ,-0.174789429f ,-0.996246338f ,
 0.956481934f , 0.130310059f , 0.146255493f ,-0.002822876f , 0.022857666f ,-0.002487183f , 0.001480103f , 0.000076294f },

{-0.000106812f ,-0.001785278f , 0.001617432f ,-0.025909424f ,-0.008316040f ,-0.151306152f ,-0.198059082f ,-1.014617920f ,
 0.935195923f , 0.109161377f , 0.143676758f ,-0.006134033f , 0.021789551f ,-0.002700806f , 0.001388550f , 0.000061035f ,
-0.000106812f ,-0.001907349f , 0.001266479f ,-0.026840210f ,-0.012420654f ,-0.151962280f ,-0.221984863f ,-1.031936646f ,
 0.913055420f , 0.088775635f , 0.140670776f ,-0.009231567f , 0.020690918f ,-0.002883911f , 0.001296997f , 0.000061035f },

{-0.000122070f ,-0.002014160f , 0.000869751f ,-0.027725220f ,-0.016708374f ,-0.152069092f ,-0.246505737f ,-1.048156738f ,
 0.890090942f , 0.069168091f , 0.137298584f ,-0.012115479f , 0.019577026f ,-0.003051758f , 0.001205444f , 0.000045776f ,
-0.000137329f ,-0.002120972f , 0.000442505f ,-0.028533936f ,-0.021179199f ,-0.151596069f ,-0.271591187f ,-1.063217163f ,
 0.866363525f , 0.050354004f , 0.133590698f ,-0.014801025f , 0.018463135f ,-0.003173828f , 0.001113892f , 0.000045776f },

{-0.000152588f ,-0.002243042f ,-0.000030518f ,-0.029281616f ,-0.025817871f ,-0.150497437f ,-0.297210693f ,-1.077117920f ,
 0.841949463f , 0.032379150f , 0.129562378f ,-0.017257690f , 0.017349243f ,-0.003280640f , 0.001037598f , 0.000030518f ,
-0.000167847f ,-0.002349854f ,-0.000549316f ,-0.029937744f ,-0.030609131f ,-0.148773193f ,-0.323318481f ,-1.089782715f ,
 0.816864014f , 0.015228271f , 0.125259399f ,-0.019531250f , 0.016235352f ,-0.003372192f , 0.000961304f , 0.000030518f },

{-0.000198364f ,-0.002456665f ,-0.001098633f ,-0.030532837f ,-0.035552979f ,-0.146362305f ,-0.349868774f ,-1.101211548f ,
 0.791213989f ,-0.001068115f , 0.120697021f ,-0.021575928f , 0.015121460f ,-0.003417969f , 0.000885010f , 0.000030518f ,
-0.000213623f ,-0.002578735f ,-0.001693726f ,-0.031005859f ,-0.040634155f ,-0.143264771f ,-0.376800537f ,-1.111373901f ,
 0.765029907f ,-0.016510010f , 0.115921021f ,-0.023422241f , 0.014022827f ,-0.003463745f , 0.000808716f , 0.000030518f },

{-0.000244141f ,-0.002685547f ,-0.002334595f ,-0.031387329f ,-0.045837402f ,-0.139450073f ,-0.404083252f ,-1.120223999f ,
 0.738372803f ,-0.031082153f , 0.110946655f ,-0.025085449f , 0.012939453f ,-0.003479004f , 0.000747681f , 0.000015259f ,
-0.000259399f ,-0.002792358f ,-0.003005981f ,-0.031661987f ,-0.051132202f ,-0.134887695f ,-0.431655884f ,-1.127746582f ,
 0.711318970f ,-0.044784546f , 0.105819702f ,-0.026535034f , 0.011886597f ,-0.003479004f , 0.000686646f , 0.000015259f },

{-0.000289917f ,-0.002899170f ,-0.003723145f ,-0.031814575f ,-0.056533813f ,-0.129577637f ,-0.459472656f ,-1.133926392f ,
 0.683914185f ,-0.057617187f , 0.100540161f ,-0.027801514f , 0.010848999f ,-0.003463745f , 0.000625610f , 0.000015259f ,
-0.000320435f ,-0.002990723f ,-0.004486084f ,-0.031845093f ,-0.061996460f ,-0.123474121f ,-0.487472534f ,-1.138763428f ,
 0.656219482f ,-0.069595337f , 0.095169067f ,-0.028884888f , 0.009841919f ,-0.003433228f , 0.000579834f , 0.000015259f },

{-0.000366211f ,-0.003082275f ,-0.005294800f ,-0.031738281f ,-0.067520142f ,-0.116577148f ,-0.515609741f ,-1.142211914f ,
 0.628295898f ,-0.080688477f , 0.089706421f ,-0.029785156f , 0.008865356f ,-0.003387451f , 0.000534058f , 0.000015259f ,
-0.000396729f ,-0.003173828f ,-0.006118774f ,-0.031478882f ,-0.073059082f ,-0.108856201f ,-0.543823242f ,-1.144287109f ,
   0.600219727f ,-0.090927124f , 0.084182739f ,-0.030517578f , 0.007919312f ,-0.003326416f , 0.000473022f , 0.000015259f}
};
