# make sure we find packages
package require -exact snack 2.2
package require BWidget
#########################################
#set info(redoSnd) [sound]
set info(concatSnd) [sound]
set info(tmpSnd) [sound]
set ::info(recDir) [file join [pwd] rec]

proc numberTTS { parent} {
global info
pack [frame $parent.topLab2]
pack [label $parent.topLab2.l1 -text "recDir" ] -side left
pack [button $parent.topLab2.open -image [Bitmap::get openfold] -command {setRecDir} -relief flat] -side left
pack [label $parent.topLab2.l2 -textvariable info(recDir) ]

pack [frame $parent.f3 ]
pack [label $parent.f3.l2 -text "Number to speak:" -padx 11 -pady 2 -bg white -width 20 -font "arial 14"] -side left 
pack [entry $parent.f3.e -textvariable info(numToSpeak) -width 6 -font "arial 14"] -side left 
pack [ button $parent.f3.b1 -text "Play" -command {playConcat} -padx 11 -pady 2  -width 6 -font "arial 14"] -side left 
bind $parent.f3.e <Return> playConcat
}

set parent [frame .f]
pack $parent
numberTTS $parent
raise $parent
focus -force $parent.f3.e

################################################################ 
##########		Procs	to edit and play			########## 
################################################################ 

proc setRecDir {} {
set selected [tk_chooseDirectory]
if {!($selected == "")} {
set ::info(recDir) $selected 
}
}

proc playConcat {} {
 global info
 set num $info(numToSpeak)
 set fileList [constituate $num]
puts $fileList 
 concatFiles $fileList
 $info(concatSnd) play
}

proc concatFiles {fileList} {
global info
 $info(concatSnd) length 0
 foreach file $fileList {
  if {[file exists $::info(recDir)/$file.wav]} {
   $info(tmpSnd) read $::info(recDir)/$file.wav
   $info(concatSnd) concatenate $info(tmpSnd)
}
 }
}

proc constituate {inp} {
set thousandtPart [expr int(floor($inp/1000000))]
set rest [expr $inp - [expr $thousandtPart*1000000]]
set hundredtPart [expr int(floor($rest/100000))]
set rest [expr $rest - [expr $hundredtPart*100000]]
if {$rest >= 20000} {
set tentPart [expr int(floor($rest/10000))*10]
set rest [expr $rest - [expr $tentPart*1000]]
} else {
set tentPart 0
}
set thousandPart [expr int(floor($rest/1000))]
set rest [expr $rest - [expr $thousandPart*1000]]
set hundredPart [expr int(floor($rest/100))]
set rest [expr $rest - [expr $hundredPart*100]]
if {$rest >= 20} {
set tenPart [expr int(floor($rest/10))*10]
set rest [expr $rest - [expr $tenPart]]
} else {
set tenPart 0
}
set onePart $rest
if {$thousandtPart>0} {lappend result $thousandtPart}
if {$hundredtPart>0} {lappend result $hundredtPart 100}
if {$tentPart>0} {lappend result $tentPart}
if {$thousandPart>0} {lappend result $thousandPart 1000}
if {$hundredPart>0} {lappend result $hundredPart 100}
if {$tenPart>0} {lappend result $tenPart}
if {$onePart>0} {lappend result $onePart}
puts "constituate $result"
return $result
}
