package provide app-ntts 1.0
package require BWidget

 # make sure we find packages
# set ::auto_path [concat [file join $::info(appRootDir) lib] $::auto_path]
#package require -exact snack 2.2
# source [file join $::info(appRootDir) lib/sdetProcs.tcl]
source sdetProcs.tcl
#console show
#########################################
set info(redoSnd) [sound]
set info(concatSnd) [sound]
set info(tmpSnd) [sound]
set info(radioChoice) "1 2 3 4 5 6 7 8 9 10"
set info(silSamples) 0
set info(recDir) [file join [pwd] rec]

proc numberTTS { parent} {
global info
pack [frame $parent.topLab2]
pack [label $parent.topLab2.l1 -text "recDir" ] -side left
pack [button $parent.topLab2.open -image [Bitmap::get openfold] -command {setRecDir} -relief flat] -side left
pack [label $parent.topLab2.l2 -textvariable info(recDir) ]

pack [frame $parent.topLab]
pack [ label $parent.topLab.l1 -text "" -textvariable ::numberLabel -width 28 -pady 2 -bg white -font "arial 14"] -side left

pack [frame $parent.f0 ]
radiobutton $parent.f0.rb1 -text "Record 1-10" -variable info(radioChoice) -value "1 2 3 4 5 6 7 8 9 10"
radiobutton $parent.f0.rb2 -text "Record 11-19" -variable info(radioChoice) -value "11 12 13 14 15 16 17 18 19"
radiobutton $parent.f0.rb3 -text "Record 20-1000" -variable info(radioChoice) -value "20 30 40 50 60 70 80 90 100 1000"
pack $parent.f0.rb1 $parent.f0.rb2 $parent.f0.rb3 -side left

pack [frame $parent.f1 ]
pack [ button $parent.f1.cc -text "Start auto rec" -command [list Start {}] -fg red -padx 11 -pady 2 -bg white -font "arial 14" -width 16]
set info(listenLabel) [label $parent.f1.l1 -text "" -padx 11 -pady 2 -bg white -width 48 ]
pack $info(listenLabel) -side top
pack [frame $parent.f15 ]
pack [ label $parent.f15.l -text "" -width 18 -pady 2 -font "arial 14"]

pack [frame $parent.f4] 
pack [label $parent.f4.l1 -width 10 -text recLevel] -side left 
pack [entry $parent.f4.e1 -width 5 -textvariable info(sDet,recLevel)] -side left 
pack [label $parent.f4.l2 -width 10 -text backoff] -side left 
pack [entry $parent.f4.e2 -width 5 -textvariable info(sDet,backoff)] -side left 
pack [label $parent.f4.l4 -width 10 -text tsilence] -side left 
pack [entry $parent.f4.e4 -width 5 -textvariable info(sDet,tsilence)] -side left 

pack [frame $parent.f6 ]
#pack [label $parent.f6.l2 -text "Samples to add between:" -padx 11 -pady 2 -bg white -width 20] -side left 
#pack [entry $parent.f6.e -textvariable info(silSamples) -width 6] -side left 
#pack [label $parent.f6.l3 -text "" -padx 11 -pady 2 -width 18] -side left 

pack [frame $parent.f3 ]
pack [label $parent.f3.l2 -text "Number to speak:" -padx 11 -pady 2 -bg white -width 20] -side left 
pack [entry $parent.f3.e -textvariable info(numToSpeak) -width 6] -side left 
pack [ button $parent.f3.b1 -text "Play" -command {playConcat} -padx 11 -pady 2  -width 6] -side left 
pack [ button $parent.f3.b2 -text "" -padx 11 -pady 2 -width 6 -relief flat] -side left 


pack [frame $parent.f5 ]
pack [ button $parent.f5.b5 -text "-" -command {removeFromFront} -padx 11 -pady 2 -width 1] -side left 
pack [ button $parent.f5.b6 -text "+" -command {addToFront} -padx 11 -pady 2 -width 1] -side left 
pack [label $parent.f5.l2 -text "Number to edit/redo:" -padx 11 -pady 2 -bg white -width 20] -side left 
pack [entry $parent.f5.e -textvariable info(numToEdit) -width 6] -side left 

pack [ button $parent.f5.b1 -text "Play" -command {playFile} -padx 11 -pady 2  -width 6] -side left 
pack [ button $parent.f5.b2 -text "Redo rec" -command {redoRec} -padx 11 -pady 2 -width 6] -side left 
pack [ button $parent.f5.b4 -text "-" -command {removeFromEnd} -padx 11 -pady 2 -width 1] -side left 
pack [ button $parent.f5.b3 -text "+" -command {addToEnd} -padx 11 -pady 2 -width 1] -side left 

pack [frame $parent.f7 ] -side bottom
pack [canvas $parent.f7.cSpec -height 100 -width 500] -side left
$parent.f7.cSpec create spectrogram 0 0 -sound $info(redoSnd) -height 100 -width 500

pack [frame $parent.f8 ] -side bottom
pack [canvas $parent.f8.cWav -height 100 -width 500 -bg white] -side left
$parent.f8.cWav create waveform 0 0 -sound $info(redoSnd) -width 500 -height 100


#pack [frame $parent.f2 ] -anchor w

#bind all <Control-a> Start
bind $parent.f3.e <Return> playConcat
bind $parent.f5.e <Return> playFile
bind $parent.f5.e <Control-r> redoRec
bind $parent.f5.e <Control-p> playConcat
}

set parent [frame .f]
pack $parent
numberTTS $parent
raise $parent
focus -force $parent.f3.e

################################################################ 
##########    Procs to record autoList                ########## 
################################################################ 
proc setRecDir {} {
global info
set selected [tk_chooseDirectory]
if {!($selected == "")} {
set info(recDir) $selected 
}
}


proc Stop {} {
global sdet parent
 $parent.f1.cc configure -fg red -bg white 
 $info(sDet,TmpSnd) stop
 $info(sDet,Snd) stop
 $info(sDet,TmpSnd) length 0
 after cancel Update
# puts "Stop:canceled Update"
}

proc 010 {} {
set listOfThingsToSay {1 2 3 4 5 6 7 8 9 10}
Start $listOfThingsToSay
}

proc 1119 {} {
set listOfThingsToSay {11 12 13 14 15 16 17 18 19}
Start $listOfThingsToSay
}

proc 201000 {} {
set listOfThingsToSay {20 30 40 50 60 70 80 90 100 1000}
Start $listOfThingsToSay
}

proc Start {listOfThingsToSay} {
global info sdet parent
if {$listOfThingsToSay == ""} {
set listOfThingsToSay $info(radioChoice)
#set listOfThingsToSay {1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 30 40 50 60 70 80 90 100 1000}
puts "listOfThingsToSay =$listOfThingsToSay "
}
$parent.f1.cc configure -fg white -bg red
  $info(sDet,TmpSnd) record
  set info(sdet,listenFlag) 1
after 500 [listen $listOfThingsToSay]
puts "Start:after call to listen"
}

proc listen {listOfThingsToSay} {
global info
foreach number $listOfThingsToSay {
after 500
set ::numberLabel "Done"
after 500
set ::numberLabel "speak: $number"
set info(number) $number
puts "proc listen  number $number "
sDetListen
vwait ::stopvar
set ::stopvar 0
}
set ::numberLabel "All Done"
StopListen 
UpdateSpectrogram
}

proc processWav {} {
global info
set recdir [pwd]/rec
if {![file isdirectory $recdir]} {
file mkdir rec
}
$info(sDet,SndTot) write $info(recDir)/$info(number).wav
$info(sDet,SndTot) length 0
}

################################################################ 
##########		Procs	to edit and play			########## 
################################################################ 
proc UpdateSpectrogram {} {
 global info
 set num $info(numToEdit)
 if {[file exists $info(recDir)/$num.wav]} {
$info(redoSnd) read $info(recDir)/$num.wav
update 
}
}

proc playConcat {} {
 global info
 set num $info(numToSpeak)
 set fileList [constituate $num]
puts $fileList 
 concatFiles $fileList
 $info(concatSnd) play
}

proc playFile {} {
 global info
 set num $info(numToEdit)
 if {[file exists $info(recDir)/$num.wav]} {
  $info(redoSnd) read $info(recDir)/$num.wav
  $info(redoSnd) play
 }
}

proc concatFiles {fileList} {
global info
 $info(concatSnd) length 0
 foreach file $fileList {
  if {[file exists $info(recDir)/$file.wav]} {
   $info(sDet,TmpSnd) read $info(recDir)/$file.wav
   $info(concatSnd) concatenate $info(sDet,TmpSnd)
$info(concatSnd) length [expr [$info(concatSnd) length]+ $info(silSamples)]  }
 }
}

proc redoRec {} {
global info
set choice [tk_messageBox -type yesnocancel -default yes -message "Do you want to redo recording $info(numToEdit)?" -icon question]
puts "choice=$choice" 
if {$choice == "yes"} {
Start $info(numToEdit)
} else {
#Do nothing
}
}

proc testRec {} {
global info
set numbers [constituate $info(numToSpeak)]
set choice [tk_messageBox -type yesnocancel -default yes -message "Will record (replace) numbers: $numbers ?" -icon question]
if {$choice == "yes"} {
Start $numbers
}
}

proc removeFromEnd {} {
global info
set file $info(numToEdit)
$info(redoSnd) length [expr [$info(redoSnd) length]-500]
set x [$info(redoSnd) length]
puts "$info(numToEdit) length=$x "
$info(redoSnd) write $info(recDir)/$info(numToEdit).wav
}


proc addToEnd {} {
global info
set file $info(numToEdit)
$info(redoSnd) length [expr [$info(redoSnd) length]+500]
set x [$info(redoSnd) length]
puts "$info(numToEdit) length=$x "
$info(redoSnd) write $info(recDir)/$info(numToEdit).wav
}

proc removeFromFront {} {
global info
set file $info(numToEdit)
$info(redoSnd) cut 0 500
$info(redoSnd) write $info(recDir)/$info(numToEdit).wav
}

proc addToFront {} {
global info
set file $info(numToEdit)
$info(tmpSnd) length 500
$info(tmpSnd) concatenate $info(redoSnd)
$info(redoSnd) copy $info(tmpSnd)
$info(redoSnd) write $info(recDir)/$info(numToEdit).wav
}

proc constituate {inp} {
set thousandtPart [expr int(floor($inp/1000000))]
set rest [expr $inp - [expr $thousandtPart*1000000]]
set hundredtPart [expr int(floor($rest/100000))]
set rest [expr $rest - [expr $hundredtPart*100000]]
if {$rest >= 20000} {
set tentPart [expr int(floor($rest/10000))*10]
set rest [expr $rest - [expr $tentPart*1000]]
} else {
set tentPart 0
}
set thousandPart [expr int(floor($rest/1000))]
set rest [expr $rest - [expr $thousandPart*1000]]
set hundredPart [expr int(floor($rest/100))]
set rest [expr $rest - [expr $hundredPart*100]]
if {$rest >= 20} {
set tenPart [expr int(floor($rest/10))*10]
set rest [expr $rest - [expr $tenPart]]
} else {
set tenPart 0
}
set onePart $rest
if {$thousandtPart>0} {lappend result $thousandtPart}
if {$hundredtPart>0} {lappend result $hundredtPart 100}
if {$tentPart>0} {lappend result $tentPart}
if {$thousandPart>0} {lappend result $thousandPart 1000}
if {$hundredPart>0} {lappend result $hundredPart 100}
if {$tenPart>0} {lappend result $tenPart}
if {$onePart>0} {lappend result $onePart}
puts "constituate $result"
return $result
}
