############################
# Done 23:04 07.12.2004
############################

#console show

package require -exact snack 2.2

file delete _tmprec.wav
set info(sDet,Snd) [snack::sound]
set info(sDet,TmpSnd) [snack::sound]
set info(sDet,SndTot) [snack::sound]
$info(sDet,TmpSnd) write _tmprec.wav

set info(sDet,backoff) 2000
set info(sDet,recLevel) 4000
set info(sDet,tsilence) 5500
set info(sDet,state) 0
set info(sDet,listenFlag) 0
set info(sDet,recOn) 0
set info(sDet,silLength) 0
set info(sDet,backoffAdded) 0
set info(sDet,Maxrec) 100000

proc StopListen {} {
 global info
set ::stopvar 1
 $info(sDet,Snd) stop
 $info(sDet,TmpSnd) stop
 after cancel stateSwitch
if {[info exists info(listenLabel)]} {$info(listenLabel) configure -bg "light green" -text done}
}

proc sDetListen {} {
 global info
	set info(sDet,listenFlag) 1
	$info(sDet,TmpSnd) length 0
	$info(sDet,Snd) length 0
	$info(sDet,SndTot) length 0
	$info(sDet,TmpSnd) record
	stateSwitch
}
 
proc setRecState {} {
    global info
    if {[$info(sDet,TmpSnd) max] > $info(sDet,recLevel)} {
	set info(sDet,state) sound
	if {[info exists info(listenLabel)]} {$info(listenLabel) configure -bg red -text sound}
	set info(sDet,recOn) 1
    } else {
	if {$info(sDet,silLength) < $info(sDet,tsilence)} {
	    set info(sDet,state) silence
	    if {[info exists info(listenLabel)]} {$info(listenLabel) configure -bg "yellow" -text silence}
	} else {
	    set info(sDet,state) done
	    if {[info exists info(listenLabel)]} {$info(listenLabel) configure -bg "light green" -text done}
	}
    } 
}


proc addBackoff {} {
    global info
    set start [expr [$info(sDet,TmpSnd) length] - $info(sDet,backoff)]
    $info(sDet,TmpSnd) crop $start [$info(sDet,TmpSnd) length]
    $info(sDet,SndTot) concatenate $info(sDet,TmpSnd)
    $info(sDet,TmpSnd) length 0
    set info(sDet,backoffAdded) 1
puts "backoff added" 
}

proc stateSwitch {} {
    global info
    if {$info(sDet,listenFlag)} {
	setRecState
	if {$info(sDet,recOn)} {
	    if {!($info(sDet,backoffAdded))} {
		addBackoff
		$info(sDet,Snd) record -append 1
	    }
	    switch $info(sDet,state) {
		sound {
		    puts "sound recording  tLength=[$info(sDet,TmpSnd) length] silLength=$info(sDet,silLength) tMax=[$info(sDet,TmpSnd) max]"
		    set info(sDet,silLength) 0
		    $info(sDet,TmpSnd) length 0
		}
		silence {
		    puts "silence but recording  tLength=[$info(sDet,TmpSnd) length] silLength=$info(sDet,silLength) tMax=[$info(sDet,TmpSnd) max]"
		    incr info(sDet,silLength) [$info(sDet,TmpSnd) length]
		}
		done {
		    puts "Done tLength=[$info(sDet,TmpSnd) length] sLength=[$info(sDet,Snd) length] silLength=$info(sDet,silLength) tMax=[$info(sDet,TmpSnd) max]"
		    $info(sDet,Snd) stop
		    $info(sDet,SndTot) concatenate $info(sDet,Snd)
		    processWav
		    $info(sDet,Snd) length 0
		    $info(sDet,TmpSnd) length 0
		    set info(sDet,silLength) 0
		    set info(sDet,recOn) 0
		    set info(sDet,backoffAdded) 0
                set ::stopvar 1
		}
	    }
	}
	puts *
	after 100 stateSwitch
    }
if {[$info(sDet,TmpSnd) length]>$info(sDet,Maxrec)} {StopListen}
}

proc processWav {} {
global info
set recdir [pwd]/userRecordings
if {![file isdirectory $recdir]} {
file mkdir rec
}
$info(sDet,SndTot) write $recdir/$info(word2BSaid,currentWord).wav
}
